% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{segplot}
\alias{segplot}
\title{A visual representation of segregation}
\usage{
segplot(
  data,
  group,
  unit,
  weight,
  order = "segregation",
  secondary_plot = NULL,
  reference_distribution = NULL,
  bar_space = 0,
  hline = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the first dimension
over which segregation is computed.}

\item{unit}{A categorical variable or a vector of variables
contained in \code{data}. Defines the second dimension
over which segregation is computed.}

\item{weight}{Numeric. (Default \code{NULL})}

\item{order}{A character, either
"segregation", "entropy", "majority", or "majority_fixed".
Affects the ordering of the units.
The horizontal ordering of the groups can be changed
by using a factor variable for \code{group}.
The difference between "majority" and "majority_fixed" is that the former
will reorder the groups in such a way that the majority group actually comes first.
If you want to control the ordering yourself, use "majority_fixed" and specify
the \code{group} variable as a factor variable.}

\item{secondary_plot}{If \code{NULL} (default), no secondary plot is drawn.
If "segregation", a secondary plot is drawn that shows adjusted local segregation
scores for each unit. If "cumulative", a secondary plot is drawn that shows
the cumulative contribution of each unit toward the total H (calculated as the
proportion of each unit times the adjusted local segregation of each unit)0.}

\item{reference_distribution}{Specifies the reference distribution, given as
a two-column data frame, to be plotted on the right.
If order is \code{segregation}, then this reference distribution is
also used to compute the local segregation scores.}

\item{bar_space}{Specifies space between single units.}

\item{hline}{Default \code{NULL}. If a color is specified,
horizontal lines will be drawn where groups are separated.}
}
\value{
Returns a ggplot2 or patchwork object.
}
\description{
Produces a segregation plot.
}
