% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{setVarySettings}
\alias{setVarySettings}
\title{Parameters for \code{\link{segmentCluster.batch}}.}
\usage{
setVarySettings(E = c(1, 3), S = "ccor", M = 100, Mn = 100,
  a = -2, nui = c(1, 3), nextmax = TRUE, multi = "max",
  multib = "max")
}
\arguments{
\item{E}{exponent to scale similarity matrices}

\item{S}{the scoring function to be used: "ccor", "icor" or "ccls"}

\item{M}{segment length penalty. Note, that this is not a strict
cut-off but defined as a penalty that must be "overcome" by
good score.}

\item{Mn}{segment length penalty for nuisance cluster. Mn<M will
allow shorter distances between "real" segments; only used in
scoring functions "ccor" and "icor"}

\item{a}{a cluster "dissimilarity" only used for pure cluster-based
scoring w/o cluster similarity measures in scoring function
"ccls".}

\item{nui}{the similarity score to be used for nuisance clusters
in the cluster similarity matrices}

\item{nextmax}{go backwards while score is increasing before
opening a new segment, default is TRUE}

\item{multi}{handling of multiple k with max. score in forward
phase, either "min" (default) or "max"}

\item{multib}{handling of multiple k with max. score in back-trace
phase, either "min" (default), "max" or "skip"}
}
\value{
Returns a parameter settings structure that can be used
in the batch function \code{\link{segmentCluster.batch}}.
}
\description{
Generates the parameter list (\code{varySettings}) for
\code{\link{segmentCluster.batch}}, using defaults
for all parameters not passed.
}
