% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.clustering}
\alias{plot.clustering}
\title{Plot method for the "clustering" object.}
\usage{
\method{plot}{clustering}(x, k, sort = FALSE, xaxis, axes = 1:2,
  pch = 16, ylabh = TRUE, ...)
}
\arguments{
\item{x}{a "clustering" object as returned by
\code{\link{clusterTimeseries}}}

\item{k}{a numeric or string vector indicating the clusterings to be plotted;
specifically the column numbers or names in the matrix of clusterings
in \code{cset$clusters}; if missing all columns will be plotted
and the calling code must take care of properly assigning \code{par(mfcol)}
or \code{layout} for the plot}

\item{sort}{if \code{TRUE} and the clustering is yet unsorted a cluster
sorting will be calculated based on "ccor" cluster-cluster similarity
matrix \code{x$Ccc}; see \code{\link{sortClusters}}}

\item{xaxis}{optionally x-values to use as x-axis (e.g. to reflect absolute
chromosomal coordinates)}

\item{axes}{list of axes to plot, numbers as used as first argument
in function \code{axis}}

\item{pch}{argument \code{pch} (symbol) for plot}

\item{ylabh}{plot "clustering" horizontally at y-axis}

\item{...}{additional arguments to plot, eg. to set point \code{cex}}
}
\value{
returns the input "clustering" object with (potentially new)
cluster sorting and colors as in shown in the plot
}
\description{
plot the clustering object returned by \code{\link{clusterTimeseries}}
}
