% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\alias{print.dp}
\alias{print.smw}
\alias{bp}
\alias{extract.smw}
\alias{bp.dp}
\title{Extract results and breakpoints from a \code{smw} object}
\usage{
\method{extract}{smw}(smw, w = NULL, index = "dp", sig = "z",
  z = 1.85, BPs = "max", seq.sig = 3)

\method{bp}{dp}(dp)
}
\arguments{
\item{smw}{An object of class \code{smw} resulted from the \code{\link{SMW}} analysis.}

\item{w}{Numeric. A "target" window size from which results will be extracted (see Details). Only effective if the \code{smw} object contains results from multiple window sizes.}

\item{index}{The result to be extracted:
\itemize{
  \item \code{"dp"}: The dissimilarity profile (DP) table containing significant discontinuities and suggested breakpoints.  The returned DP has class \code{"dp"}, with an own generic \code{print} method. The \code{print} command prints and returns invisibly the DP.
  \item \code{"rdp"}: data frame containing the randomized DP;
  \item \code{"md"}: mean dissimilarity of the randomized DP;
  \item \code{"sd"}: standard deviation for each sample position;
  \item \code{"oem"}: overall expected mean dissimilarity;
  \item \code{"osd"}: average standard deviation for the dissimilarities;
  \item \code{"params"}: list with input arguments
}}

\item{sig}{Significance test for detecting dissimilarity values that differs significantly from those appearing in a random pattern. The following tests are considered with default to \code{sig.test="z"}:
\itemize{
  \item \code{"dp"} consider normalized dissimilarity (z-scores) discontinuities that exceed a "z" critical value;
  \item \code{"sd"} consider dissimilarity discontinuities that exceed mean plus one standard deviation;
  \item \code{"SD2"} consider dissimilarity discontinuities that exceed mean plus two standard deviation;
  \item \code{"tail1"} Consider dissimilarity discontinuities that exceed 95 percent confidence limits.
}}

\item{z}{The critical value for the significance of z-values. Defaults to \code{'z=1.85'} (Erdös et.al, 2014).}

\item{BPs}{Defines if the breakpoints should be chosen as those sample positions corresponding to the maximum dissimilarity in a sequence of significant values (\code{"max"}) or as those sample positions corresponding to the median position of the sequence (\code{"median"}). Defaults to \code{BPs="max"}. If \code{NULL} the breakpoints are not computed.}

\item{seq.sig}{The maximum length of consecutive, significant values of dissimilarity that will be considered in defining the community breakpoints. Defaults to \code{seq.sig=3};}

\item{dp}{An object of class \code{dp} (see Details).}
}
\value{
\itemize{
  \item \code{"extract"} returns a result called by the argument \code{index} (see Details);
  \item \code{"bp"} returns the locations of the breakpoints.
  }
}
\description{
Functions to extract results and breakpoints from a \code{smw} object
}
\details{
If the \code{smw} object contains results from multiple window sizes, the DP table will be based on the average Z-score over the set of analysed window sizes.  Available methods for class \code{"dp"} are \code{print}, \code{bp} and \code{plot}.

The argument \code{w} is optional. If the \code{smw} object is length 1, \code{w} is ignored. If \code{length(smw)>1} and \code{w} is \code{NULL}, the function will extract the dissimilarity profile averaged over the set of window sizes.
}
\examples{
data(sim1)
sim1o<-OrdData(sim1$envi,sim1$comm)
\dontshow{
ws50<-SMW(yo=sim1o$yo,ws=50, n.rand=3)
extract(ws50)
}
\donttest{
ws50<-SMW(yo=sim1o$yo,ws=50)
ws50_dp<-extract(ws50)
head(ws50_dp)
}
}
\seealso{
\code{\link{plot.smw}}.
}
