% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_densities.R
\name{plot_densities}
\alias{plot_densities}
\title{Prior and posterior plots}
\usage{
plot_densities(
  fit,
  file_path,
  n_col = 4,
  alpha = 0.05,
  save = TRUE,
  title = TRUE,
  device = "jpg",
  width = 10,
  height = 2,
  units = "in"
)
}
\arguments{
\item{fit}{fitted object}

\item{file_path}{file path for plots}

\item{n_col}{number of columns for grid plots}

\item{alpha}{cut off value for posterior (only used if
\code{plot_type = "density"})}

\item{save}{boolean indicating if plots should be saved, if \code{FALSE}, the
plots will be printed instead, default is \code{save = FALSE} (ignored if
\code{file_path} is provided)}

\item{title}{boolean indicating if plots should contain titles}

\item{device}{character string with format used in \code{ggsave}}

\item{width}{plot width in \code{units}, for grid plots adjusted for the
number of plot columns \code{n_col}}

\item{height}{plot height in \code{units}, for grid plots adjusted for the
number of plot rows implied by \code{n_col}}

\item{units}{units for plot size (\code{"in", "cm", "mm", or "px"})}
}
\value{
nothing
}
\description{
Creates diagnostic plots of the posterior distribution.
}
\keyword{internal}
