% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducibility-tools.R
\name{ReproducibilityManager}
\alias{ReproducibilityManager}
\title{Search Reproducibility Manager}
\description{
A comprehensive system for managing and validating the reproducibility
of systematic review search strategies and analyses.
}
\details{
The ReproducibilityManager class provides tools for:
\itemize{
\item Creating reproducible search packages
\item Validating reproducibility of existing packages
\item Generating audit trails
\item Ensuring transparency and reproducibility in evidence synthesis
}
}
\section{Methods}{

\describe{
\item{\code{new()}}{Initialize a new ReproducibilityManager instance}
\item{\code{create_repro_package(search_strategy, results, analysis_config)}}{Create reproducible search package}
\item{\code{validate_repro(package_path)}}{Validate reproducibility of existing package}
\item{\code{gen_audit_trail(search_analysis)}}{Generate audit trail}
}
}

\examples{
# Create reproducibility manager
manager <- ReproducibilityManager$new()

# Create sample search strategy
search_strategy <- list(
  terms = c("systematic review", "meta-analysis"),
  databases = c("PubMed", "Embase"),
  timestamp = Sys.time(),
  date_range = as.Date(c("2020-01-01", "2023-12-31"))
)

# Create sample search results
search_results <- data.frame(
  id = paste0("article_", 1:20),
  title = paste("Research Study", 1:20),
  abstract = paste("Abstract for study", 1:20),
  source = "Journal of Research",
  date = Sys.Date() - sample(1:365, 20, replace = TRUE),
  stringsAsFactors = FALSE
)

# Create sample analysis configuration
analysis_config <- list(
  gold_standard = paste0("article_", sample(1:20, 5)),
  method = "precision_recall",
  parameters = list(threshold = 0.8)
)

# Create reproducible package (writes to tempdir())
package_path <- manager$create_repro_package(
  search_strategy = search_strategy,
  results = search_results,
  analysis_config = analysis_config
)

print(paste("Package created at:", package_path))

# Generate audit trail (create mock analyzer object for demonstration)
mock_analysis <- list(
  search_results = search_results,
  metadata = list(timestamp = Sys.time())
)
class(mock_analysis) <- "mock_analyzer"

audit_trail <- manager$gen_audit_trail(mock_analysis)
print("Audit trail generated successfully")

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReproducibilityManager-new}{\code{ReproducibilityManager$new()}}
\item \href{#method-ReproducibilityManager-create_repro_package}{\code{ReproducibilityManager$create_repro_package()}}
\item \href{#method-ReproducibilityManager-validate_repro}{\code{ReproducibilityManager$validate_repro()}}
\item \href{#method-ReproducibilityManager-gen_audit_trail}{\code{ReproducibilityManager$gen_audit_trail()}}
\item \href{#method-ReproducibilityManager-clone}{\code{ReproducibilityManager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReproducibilityManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-ReproducibilityManager-new}{}}}
\subsection{Method \code{new()}}{
Creates a new ReproducibilityManager instance for managing search reproducibility.
Sets up necessary configurations and validates system requirements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReproducibilityManager$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value, called for side effects (initialization)
Create reproducible search package
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReproducibilityManager-create_repro_package"></a>}}
\if{latex}{\out{\hypertarget{method-ReproducibilityManager-create_repro_package}{}}}
\subsection{Method \code{create_repro_package()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReproducibilityManager$create_repro_package(
  search_strategy,
  results,
  analysis_config
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_strategy}}{Search strategy object}

\item{\code{results}}{Search results}

\item{\code{analysis_config}}{Analysis configuration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Path to reproducibility package
Validate reproducibility of existing package
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReproducibilityManager-validate_repro"></a>}}
\if{latex}{\out{\hypertarget{method-ReproducibilityManager-validate_repro}{}}}
\subsection{Method \code{validate_repro()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReproducibilityManager$validate_repro(package_path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{package_path}}{Path to reproducibility package}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Validation results
Generate audit trail
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReproducibilityManager-gen_audit_trail"></a>}}
\if{latex}{\out{\hypertarget{method-ReproducibilityManager-gen_audit_trail}{}}}
\subsection{Method \code{gen_audit_trail()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReproducibilityManager$gen_audit_trail(search_analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_analysis}}{SearchAnalyzer object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Audit trail object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReproducibilityManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ReproducibilityManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReproducibilityManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
