% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dm_ae_ds_death.R
\name{check_dm_ae_ds_death}
\alias{check_dm_ae_ds_death}
\title{Check if death reported in DM then death indicator also present in DS or AE}
\usage{
check_dm_ae_ds_death(DM, DS, AE)
}
\arguments{
\item{DM}{Demographics SDTM dataset with variables USUBJID, DTHFL, DTHDTC}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSDECOD, DSSTDTC}

\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDTHDTC, AESDTH, AEOUT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This checks that when death is indicated in DM with either of DTHFL or
DTHDTC then there should be death indicated in either AE or DS.
}
\examples{

AE <- data.frame(
 STUDYID = 1,
 USUBJID = 1:3,
 AEDTHDTC = c(NA,1,NA),
 AESDTH = c(NA,"Y",NA),
 AEOUT = c(NA,"FATAL",NA),
 AETOXGR = c(NA,"5",NA)
)

DS <- data.frame(
 STUDYID = 1,
 USUBJID = 1:3,
 DSDECOD = c(NA,"DEATH",NA),
 DSSTDTC = c(NA,"DSDATE",NA)
)

DM <- data.frame(
 STUDYID = 1,
 USUBJID = 1:3,
 DTHFL=c(NA,"Y","Y"),
 DTHDTC = c(NA,"DMDATE","DMDATE")
 )

check_dm_ae_ds_death(DM,DS,AE)

DS$DSDECOD = NULL

check_dm_ae_ds_death(DM,DS,AE)

}
\author{
Sara Bodach
}
