% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_death.R
\name{check_ae_death}
\alias{check_ae_death}
\title{Check for Grade 5 AE death variable consistency}
\usage{
check_ae_death(AE, preproc = identity, ...)
}
\arguments{
\item{AE}{Adverse Event dataframe with variables USUBJID,AETOXGR,AEOUT,AEDTHDTC,AESDTH}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
Checks for grade 5 AEs not marked fatal (AEOUT), death not indicated (AESDTH), or no death date (AESDTHDTC)
}
\examples{

 AE <- data.frame(
 USUBJID = 1:10,
 AETOXGR = c(1:5,5,5,5,5,5),
 AEDTHDTC = c(rep(NA,4),rep("2020-01-01",6)),
 AESDTH = c(rep(NA,4),rep("Y",6)),
 AEOUT = c(rep(NA,4),rep("FATAL",6)),
  AESPID = "FORMNAME-R:13/L:13XXXX"
)

check_ae_death(AE)
check_ae_death(AE,preproc=roche_derive_rave_row)

AE$AEDTHDTC[5]="NA"
AE$AEDTHDTC[6]=NA
AE$AEDTHDTC[7]=""
AE$AESDTH[8]=NA
AE$AEOUT[9]=NA

check_ae_death(AE)
check_ae_death(AE,preproc=roche_derive_rave_row)

}
\author{
Iris Zhao
}
