% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scregclust.R
\name{scregclust}
\alias{scregclust}
\title{Uncover gene modules and their regulatory programs from single-cell data}
\usage{
scregclust(
  expression,
  genesymbols,
  is_regulator,
  penalization,
  n_modules,
  initial_target_modules = NULL,
  sample_assignment = NULL,
  center = TRUE,
  split1_proportion = 0.5,
  total_proportion = 1,
  split_indices = NULL,
  prior_indicator = NULL,
  prior_genesymbols = NULL,
  prior_baseline = 1e-06,
  prior_weight = 0.5,
  min_module_size = 0L,
  allocate_per_obs = TRUE,
  noise_threshold = 0.025,
  n_cycles = 50L,
  use_kmeanspp_init = TRUE,
  n_initializations = 50L,
  max_optim_iter = 10000L,
  tol_coop_rel = 1e-08,
  tol_coop_abs = 1e-12,
  tol_nnls = 1e-04,
  compute_predictive_r2 = TRUE,
  compute_silhouette = FALSE,
  nowarnings = FALSE,
  verbose = TRUE,
  quick_mode = FALSE,
  quick_mode_percent = 0.1
)
}
\arguments{
\item{expression}{\verb{p x n} matrix of pre-processed single cell expression
data with \code{p} rows of genes and \code{n} columns of cells.}

\item{genesymbols}{A vector of gene names corresponding to rows of
\code{expression}. Has to be of length \code{p}.}

\item{is_regulator}{An indicator vector where \code{1} indicates that the
corresponding row in \code{expression} is a candidate
regulator. All other rows represent target genes.
Has to be of length \code{p}.}

\item{penalization}{Sparsity penalty related to the amount of regulators
associated with each module. Either a single positive
number or a vector of positive numbers.}

\item{n_modules}{Requested number of modules (integer).
If this is provided without specifying \code{initial_target_modules},
then an initial module allocation is performed on the
cross-correlation matrix of targets and genes on the first
dataset after data splitting.}

\item{initial_target_modules}{The initial assignment of target genes to
modules of length \code{sum(is_regulator == 0L)}.
If this is not specified, then see \code{n_modules} regarding
module initialization. If provided, \code{use_kmeanspp_init}
and \code{n_initializations} are ignored.}

\item{sample_assignment}{A vector of sample assignment for each cell, can
be used to perform the data splitting with
stratification. Has to be of length \code{n}.
No stratification if \code{NULL} is supplied.}

\item{center}{Whether or not genes should be centered within each subgroup
defined in \code{sample_assignment}.}

\item{split1_proportion}{The proportion to use for the first dataset during
data splitting. The proportion for the second
dataset is \code{1 - split1_proportion}. If stratification
with \code{sample_assignment} is used, then the proportion
of each strata is controlled.}

\item{total_proportion}{Can be used to only use a proportion of the supplied
observations. The proportion of the first dataset
during data splitting in relation to the full
dataset will be
\code{total_proportion * split1_proportion}.}

\item{split_indices}{Can be used to provide an explicit data split. If this
is supplied then \code{split1_proportion}, and
\code{total_proportion} are ignored.
Note that if \code{sample_assigment} is provided and
\code{center == TRUE}, then subgroup centering will be
performed as in the case of random splitting.
A vector of length \code{n} containing entries 1 for cells
in the first data split, 2 for cells in the second
data split and \code{NA} for cells that should be excluded
from the computations.}

\item{prior_indicator}{An indicator matrix (sparse or dense) of size \verb{q x q}
that indicates whether there is a known functional
relationship between two genes. Ideally, this is
supplied as a sparse matrix (\code{sparseMatrix}
in the \code{Matrix} package). If not, then the matrix
is converted to one.}

\item{prior_genesymbols}{A vector of gene names of length q corresponding
to the rows/columns in \code{prior_indicator}. Does not
have to be the same as \code{genesymbols}, but only
useful if there is overlap.}

\item{prior_baseline}{A positive baseline for the network prior. The larger
this parameter is, the less impact the network prior
will have.}

\item{prior_weight}{A number between 0 and 1 indicating the strength of the
prior in relation to the data. 0 ignores the prior and
makes the algorithm completely data-driven. 1 uses only
the prior during module allocation.}

\item{min_module_size}{Minimum required size of target genes in a module.
Smaller modules are emptied.}

\item{allocate_per_obs}{Whether module allocation should be performed for
each observation in the second data split separately.
If \code{FALSE}, target genes are allocated into modules
on the aggregate sum of squares across all
observations in the second data split.}

\item{noise_threshold}{Threshold for the best \eqn{R^2} of a target gene
before it gets identified as noise.}

\item{n_cycles}{Number of maximum algorithmic cycles.}

\item{use_kmeanspp_init}{Use kmeans++ for module initialization if
\code{initial_target_modules} is a single integer;
otherwise use kmeans with random initial cluster
centers}

\item{n_initializations}{Number of kmeans(++) initialization runs.}

\item{max_optim_iter}{Maximum number of iterations during optimization
in the coop-Lasso and NNLS steps.}

\item{tol_coop_rel}{Relative convergence tolerance during optimization
in the coop-Lasso step.}

\item{tol_coop_abs}{Absolute convergence tolerance during optimization
in the coop-Lasso step.}

\item{tol_nnls}{Convergence tolerance during optimization in the NNLS step.}

\item{compute_predictive_r2}{Whether to compute predictive \eqn{R^2} per
module as well as regulator importance.}

\item{compute_silhouette}{Whether to compute silhouette scores for each
target gene.}

\item{nowarnings}{When turned on then no warning messages are shown.}

\item{verbose}{Whether to print progress.}

\item{quick_mode}{Whether to use a reduced number of noise targets to speed
up computations.}

\item{quick_mode_percent}{A number in [0, 1) indicating the amount of
noise targets to use in the re-allocation process
if \code{quick_mode = TRUE}.}
}
\value{
A list with S3 class \code{scregclust} containing
\item{penalization}{The supplied \code{penalization} parameters}
\item{results}{A list of result lists (each with S3 class
\code{scregclust_result}), one for each supplied \code{penalization}
parameter. See below.}
\item{initial_target_modules}{Initial allocation of target genes into
modules.}
\item{split_indices}{either verbatim the vector given as input or
a vector encoding the splits as NA = not included,
1 = split 1 or 2 = split 2. Allows reproducibility
of data splits.}

For each supplied penalization parameter, \code{results} contains a list with
\itemize{
\item the current \code{penalization} parameter,
\item the supplied \code{genesymbols} after filtering (as used during fitting),
\item the supplied \code{is_regulator} vector after filtering (as used during
fitting),
\item the number of fitted modules \code{n_modules},
\item whether the current run \code{converged} to a single configuration (as a
boolean),
\item as well as an \code{output} object containing the numeric results for each
final configuration.
}

It is possible that the algorithm ends in a finite cycle of configurations
instead of a unique final configuration.
Therefore, \code{output} is a list with each element itself being a list
with the following contents:
\describe{
\item{\code{reg_table}}{a regulator table, a matrix of weights for each
regulator and module}
\item{\code{module}}{vector of same length as \code{genesymbols} containing the
module assignments for all genes with regulators
marked as \code{NA}. Genes considered noise are marked as \code{-1}.}
\item{\code{module_all}}{same as \code{module}, however, genes that were marked as
noise (-1 in \code{module}) are assigned to the
module in which it has the largest \eqn{R^2},
even if it is below \code{noise_threshold}.}
\item{\code{r2}}{matrix of predictive \eqn{R^2} value for each target gene and
module}
\item{\code{best_r2}}{vector of best predictive \eqn{R^2} for each gene
(regulators marked with NA)}
\item{\code{best_r2_idx}}{module index corresponding to best predictive
\eqn{R^2} for each gene (regulators marked with NA)}
\item{\code{r2_module}}{a vector of predictive \eqn{R^2} values for each
module (included if \code{compute_predictive_r2 == TRUE})}
\item{\code{importance}}{a matrix of importance values for each regulator (rows)
and module (columns) (included if
\code{compute_predictive_r2 == TRUE})}
\item{\code{r2_cross_module_per_target}}{a matrix of cross module \eqn{R^2}
values for each target gene (rows)
and each module (columns) (included
if \code{compute_silhouette == TRUE})}
\item{\code{silhouette}}{a vector of silhouette scores for each target gene
(included if \code{compute_silhouette == TRUE})}
\item{\code{models}}{regulator selection for each module as a matrix with
regulators in rows and modules in columns}
\item{\code{signs}}{regulator signs for each module as a matrix with
regulators in rows and modules in columns}
\item{\code{weights}}{average regulator coefficient for each module}
\item{\code{coeffs}}{list of regulator coefficient matrices for each module
for all target genes as re-estimated in the NNLS step}
\item{\code{sigmas}}{matrix of residual variances, one per target gene
in each module; derived from the residuals in NNLS step}
}
}
\description{
Use the scRegClust algorithm to determine gene modules and their
regulatory programs from single-cell data.
}
\concept{main}
