% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scqe.1csumm}
\alias{scqe.1csumm}
\title{Stability controlled quasi-experiment (scqe) for 1 cohort case, summary
statistics}
\usage{
scqe.1csumm(
  untr_1C,
  Y_untr_1C,
  tr_1C,
  Y_tr_1C,
  delta,
  min_delta,
  max_delta,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{untr_1C}{Number of untreated individuals.}

\item{Y_untr_1C}{Outcome for untreated individuals.}

\item{tr_1C}{Number of treated individuals.}

\item{Y_tr_1C}{Outcome for treated individuals.}

\item{delta}{Single value or vector of possible values for change in
average non-treatment outcome between cohorts (if applicable).}

\item{min_delta}{Minimum delta. Optional, not used if \code{delta} is supplied.}

\item{max_delta}{Maximum delta. Optional, not used if \code{delta} is supplied.}

\item{alpha}{Numeric alpha for confidence interval (default is alpha = 0.05).}

\item{...}{Extra optional arguments.}
}
\value{
scqe object of class "scqe." Returns results table for the 1 cohort,
summary statistics case.
}
\description{
This function returns the scqe estimates and confidence intervals for the
1 cohort case when the user inputs only summary statistics.
}
\examples{
# One cohort, summary data only
scqe.1cohort.sum = scqe(untr=100,tr=200,Y_untr=5,Y_tr=50,
min_delta=.1,max_delta=1)
plot(scqe.1cohort.sum)
summary(scqe.1cohort.sum)


}
