% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{schwab_optionChain}
\alias{schwab_optionChain}
\title{Get Options Chain}
\usage{
schwab_optionChain(
  ticker,
  strikes,
  inclQuote = TRUE,
  startDate = Sys.Date() + 1,
  endDate = Sys.Date() + 360,
  contractType = c("ALL", "CALL", "PUT"),
  accessTokenList = NULL,
  range = NULL
)
}
\arguments{
\item{ticker}{underlying ticker for the options chain}

\item{strikes}{the number of strikes above and below the current strike}

\item{inclQuote}{set TRUE to include pricing details (will be delayed if
account is set for delayed quotes)}

\item{startDate}{the start date for expiration (should be greater than or
equal to today). Format: yyyy-mm-dd}

\item{endDate}{the end date for expiration (should be greater than or equal
to today). Format: yyyy-mm-dd}

\item{contractType}{can be 'ALL', 'CALL', or 'PUT'}

\item{accessTokenList}{A valid Access Token must be set using the output from
\code{\link{schwab_auth3_accessToken}}. The most recent Access Token will be
used by default unless one is manually passed into the function.}

\item{range}{Also known as moneyness. Popular choices are:
'OTM', 'ITM', 'NTM', or 'ALL'.
CAVEAT: the 'strikes' parameter must be left out
  otherwise the Schwab API will take the 'strikes' parameter
  and override the range parameter
There's also 'SAK', 'SBK', and 'SNK' for strikes above/below/near market}
}
\value{
a list of 2 data frames - underlying and options chain
}
\description{
Search an Option Chain for a specific ticker
}
\details{
Return a list containing two data frames. The first is the underlying data
for the symbol. The second item in the list is a data frame that contains the
options chain for the specified ticker.
}
\examples{
\dontrun{

# Pull all option contracts expiring over the next 6 months
# with 5 strikes above and below the at-the-money price
schwab_optionChain(ticker = 'SPY',
             strikes = 5,
             endDate = Sys.Date() + 180)

}
}
