% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_gls.R
\name{simulate_gls_once}
\alias{simulate_gls_once}
\title{Simulate and Analyze Generalized Least Squares}
\usage{
simulate_gls_once(
  n_timepoints_per_phase,
  rho,
  n_phases = 2,
  n_IDs = 1,
  betas,
  formula,
  covariate_specs = NULL
)
}
\arguments{
\item{n_timepoints_per_phase}{Integer. The number of timepoints in each phase.}

\item{rho}{Numeric. The autocorrelation parameter for the AR(1) error structure.}

\item{n_phases}{Integer. The number of phases in the design. Default is 2.}

\item{n_IDs}{Integer. The number of subjects (IDs) to simulate. Default is 1.}

\item{betas}{Named numeric vector. The true coefficient values for the model.}

\item{formula}{Formula object. The model formula to be fitted.}

\item{covariate_specs}{List of lists. Specifications for generating covariates.
Each inner list should contain elements 'vars' (variable names), 'dist'
(distribution function name), args' (list of distribution parameters), and
optionally 'expr' (a function to generate data).}
}
\value{
A list containing:
\item{success}{Logical. TRUE if the model converged, FALSE otherwise.}
\item{estimates}{Named numeric vector. Estimated coefficients from the fitted model.}
\item{std_errors}{Named numeric vector. Standard errors of the estimated coefficients.}
\item{p_values}{Named numeric vector. P-values for the estimated coefficients.}
\item{bias}{Named numeric vector. Bias of the estimated coefficients (estimate - true value).}
\item{rmse}{Numeric. Root Mean Square Error of the estimated coefficients.}
}
\description{
This function simulates data and fits a Generalized Least Squares (GLS) model
to the simulated data. It can handle multiple phases, multiple subjects (IDs),
and various covariate specifications.
}
\examples{
# Simple example with 2 phases, 10 timepoints per phase, and no covariates
result <- simulate_gls_once(
  n_timepoints_per_phase = 10,
  rho = 0.2,
  betas = c("(Intercept)" = 0, "phase1" = 1),
  formula = y ~ phase
)

}
