
<!-- README.md is generated from README.Rmd. Please edit that file -->

# scatterbar

<!-- badges: start -->
<!-- badges: end -->

`scatterbar` is an open-source R package for displaying proportional data across spatially resolved contexts. This is the `scatterbar` R documentation
website. Questions, suggestions, or problems should be submitted as
[GitHub issues](https://github.com/JEFworks-Lab/scatterbar/issues).

<p>

<img src="https://github.com/JEFworks-Lab/scatterbar/blob/main/images/scatterbar_logo_hex.png?raw=true" align="center" height="300" style="float: center; height:300px;"/>

</p>

## Overview

By combining the concepts of scatter plots and stacked bar charts,
`scatterbar` allows users to visualize variations in proportional data
data and compare across different spatial locations.

<p align="center">

<img src="https://github.com/JEFworks-Lab/scatterbar/blob/main/images/scatterbar_example.png?raw=true" height="600"/>

</p>

## Installation

To install `scatterbar`from GitHub, we recommend using `remotes`:

``` r
require(remotes)
remotes::install_github('JEFworks-Lab/scatterbar')
```

## Tutorials

- [Customizing
  Scatterbar](https://jef.works/scatterbar/articles/customizing_scatterbar.html)
- [Getting Started With
  Scatterbar](https://jef.works/scatterbar/articles/getting-started-with-scatterbars.html)
- [Using Scatterbar With Visium Files](https://jef.works/scatterbar/articles/using-scatterbar-with-visium.html)
- [Visualizing Multiple Datasets](https://jef.works/scatterbar/articles/visualizing-multiple-datasets.html)
- [Flipping Scatterbar Oreintations](https://jef.works/scatterbar/articles/flipping-scatterbar-oreintations.html)

## Citation

Our preprint describing `scatterbar` is available on *bioRxiv*:

[Velazquez D. et al. (2024), "scatterbar: an R package for visualizing proportional data across spatially resolved coordinates", *bioRxiv*](https://doi.org/10.1101/2024.08.14.606810)

