% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_sankey}
\alias{make_sankey}
\title{Create an object that describes a sankey plot}
\usage{
make_sankey(nodes = NULL, edges, y = c("optimal", "simple"),
  break_edges = FALSE, gravity = c("center", "top", "bottom"))
}
\arguments{
\item{nodes}{A data frame of nodes on the plot, and possibly
their visual style. The first column must be the ids of the
nodes. If this argument is \code{NULL}, then the ids of the
nodes are determined from \code{edges}.}

\item{edges}{A data frame of the edges. The first two columns
must be node ids, and they define the edges. The rest of the columns
contain the visual style of the edges.}

\item{y}{How to calculate vertical coordinates of nodes, if they
are not given in the input. \code{optimal} tries to minimize edge
crossings, \code{simple} simply packs nodes in the order they are
given, from bottom to top.}

\item{break_edges}{Whether to plot each edge as two segments,
or a single one. Sometimes two segment plots look better.}

\item{gravity}{Whether to push the nodes to the top, to the bottom
or to the center, within a column.}
}
\value{
A \code{sankey} object that can be plotted via the
  \code{\link{sankey}} function.x
}
\description{
Create an object that describes a sankey plot
}
\details{
The node and edges data frames may contain columns that specify
how the plot is created. All parameters have reasonable default
values.

Current list of graphical parameters for nodes:
\itemize{
  \item \code{col} Node color.
  \item \code{size} Node size.
  \item \code{x} Horizontal coordinates of the center of the node.
  \item \code{y} Vertical coordinates of the center of the node.
  \item \code{shape} Shape of the node. Possible values:
    \code{rectangle}, \code{point}, \code{invisible}.
  \item \code{lty} Lite type, see \code{par}.
  \item \code{srt} How to rotate the label, see \code{par}.
  \item \code{textcol} Label color.
  \item \code{label} Label text. Defaults to node name.
  \item \code{adjx} Horizontal adjustment of the label. See
    \code{adj} in the \code{par} manual.
  \item \code{adjy} Vertical adjustment of the label. See
    \code{adj} in the \code{par} manual.
  \item \code{boxw} Width of the node boxes.
  \item \code{cex} Label size multiplication factor.
  \item \code{top} Vertical coordinate of the top of the node.
  \item \code{center} Vertical coordinate of the center of the node.
  \item \code{bottom} Vertical coordinate of the bottom of the node.
  \item \code{pos} Position of the text label, see \code{par}.
  \item \code{textx} Horizontal position of the text label.
  \item \code{texty} Vertical position of the text label.
}

Current list of graphical parameters for edges:
\itemize{
  \item \code{colorstyle} Whether the to use a solid color (\code{col}),
    or \code{gradient} to plot the edges. The color of a gradient
    edges is between the colors of the nodes.
  \item \code{curvestyle} Edge style, \code{sin} for sinusoid curves,
    \code{line} for straight lines.
  \item \code{col} Edge color, for edges with solid colors.
  \item \code{weight} Edge weight. Determines the width of the edges.
}
}
\examples{
## Function calls in the pkgsnap package:
edges <- read.table(stringsAsFactors = FALSE, textConnection(
"                get_deps          get_description
                 get_deps               parse_deps
                 get_deps                     \%||\%
                 get_deps            drop_internal
          get_description        pkg_from_filename
               parse_deps                 str_trim
                cran_file             get_pkg_type
                cran_file          r_minor_version
            download_urls split_pkg_names_versions
            download_urls                cran_file
             pkg_download               dir_exists
             pkg_download            download_urls
             pkg_download        filename_from_url
             pkg_download             try_download
                  restore             pkg_download
                  restore        drop_missing_deps
                  restore            install_order
                  restore                 get_deps
 split_pkg_names_versions               data_frame
"))
pkgsnap_sankey <- make_sankey(edges = edges)
sankey(pkgsnap_sankey)

## Some customization
nodes <- data.frame(
  stringsAsFactors = FALSE,
  id = c("snap", sort(unique(c(edges[,1], edges[,2]))))
)
nodes$col <- ifelse(nodes$id \%in\% c("snap", "restore"), "orange", "#2ca25f")
edges$colorstyle <- "gradient"

sankey(make_sankey(nodes, edges))
}
