% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define-SOM.R
\name{report}
\alias{report}
\alias{report,SMSE-method}
\title{Generate markdown reports}
\usage{
\S4method{report}{SMSE}(
  object,
  name = object@Name,
  filename = "SMSE",
  dir = tempdir(),
  open_file = TRUE,
  render_args = list(),
  ...
)
}
\arguments{
\item{object}{\linkS4class{SMSE} object}

\item{name}{Character string for the model name to include in the report, e.g., model run number.}

\item{filename}{Character string for the name of the markdown and HTML files.}

\item{dir}{The directory in which the markdown and HTML files will be saved.}

\item{open_file}{Logical, whether the HTML document is opened after it is rendered.}

\item{render_args}{List of arguments to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}.}

\item{...}{Additional arguments (not used)}
}
\value{
Returns invisibly the output of \code{\link[rmarkdown:render]{rmarkdown::render()}}, typically the path of the output file
}
\description{
Generate a markdown report for outcomes from a single operating model projection
}
