% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{presid_2012}
\alias{presid_2012}
\title{Résultats des élections présidentielles françaises de 2012}
\format{
A data frame with 96 observations on the following 13 variables.
\describe{
\item{departement}{a factor with levels \code{Ain}
\code{Aisne} \code{Allier} \code{Alpes-de-Haute-Provence}
\code{Alpes-Maritimes} \code{Ardèche} \code{Ardennes} \code{Ariège}
\code{Aube} \code{Aude} \code{Aveyron} \code{Bas-Rhin}
\code{Bouches-du-Rhône} \code{Calvados} \code{Cantal} \code{Charente}
\code{Charente-Maritime} \code{Cher} \code{Corrèze} \code{Corse-du-Sud}
\code{Côte-d'Or} \code{Côtes-d'Armor} \code{Creuse} \code{Deux-Sèvres}
\code{Dordogne} \code{Doubs} \code{Drôme} \code{Essonne} \code{Eure}
\code{Eure-et-Loir} \code{Finistère} \code{Gard} \code{Gers} \code{Gironde}
\code{Haut-Rhin} \code{Haute-Corse} \code{Haute-Garonne} \code{Haute-Loire}
\code{Haute-Marne} \code{Haute-Saône} \code{Haute-Savoie}
\code{Haute-Vienne} \code{Hautes-Alpes} 63EmpGPcTWCqJJ9Co5Nckt8kjbdX2a3j-44\code{Hauts-de-Seine} \code{Hérault} \code{Ille-et-Vilaine} \code{Indre}
\code{Indre-et-Loire} \code{Isère} \code{Jura} \code{Landes}
\code{Loir-et-Cher} \code{Loire} \code{Loire-Atlantique} \code{Loiret}
\code{Lot} \code{Lot-et-Garonne} \code{Lozère} \code{Maine-et-Loire}
\code{Manche} \code{Marne} \code{Mayenne} \code{Meurthe-et-Moselle}
\code{Meuse} \code{Morbihan} \code{Moselle} \code{Nièvre} \code{Nord}
\code{Oise} \code{Orne} \code{Paris} \code{Pas-de-Calais} \code{Puy-de-Dôme}
63EmpGPcTWCqJJ9Co5Nckt8kjbdX2a3j-7563EmpGPcTWCqJJ9Co5Nckt8kjbdX2a3j-76\code{Rhône}
\code{Saône-et-Loire} \code{Sarthe} \code{Savoie} \code{Seine-et-Marne}
\code{Seine-Maritime} \code{Seine-Saint-Denis} \code{Somme} \code{Tarn}
\code{Tarn-et-Garonne} \code{Territoire_de_Belfort} \code{Val-dOise}
\code{Val-de-Marne} \code{Var} \code{Vaucluse} \code{Vendée} \code{Vienne}
\code{Vosges} \code{Yonne} \code{Yvelines}. Nom du département (métropole) où les suffrages ont été dénombrés.}
\item{abstentions_1}{a numeric vector. Abstentions du 1er tour.}
\item{blancs_ou_nuls_1}{a numeric vector. Bulletins blancs ou nuls au 1er tour.}
\item{bayrou}{a numeric vector. Candidat Bayrou.}
\item{hollande_1}{a numeric vector. Candidat Hollande au 1er tour.}
\item{cheminade}{a numeric vector. Candidat Cheminade.}
\item{melenchon}{a numeric vector. Candidat Mélenchon.}
\item{dupont_aignan}{a numeric vector. Candidat Dupont-Aignan.}
\item{sarkozy_1}{a numeric vector. Candidat Sarkozy au 1er tour.}
\item{poutou}{a numeric vector. Candidat Poutou.}
\item{joly}{a numeric vector. Candidate Joly.}
\item{le_pen}{a numeric vector. Candidate Le Pen.}
\item{arthaud}{a numeric vector. Candidate Arthaud.}
}
}
\usage{
presid_2012
}
\description{
Résultats par département au premier tour des élections présidentielles françaises de 2012.
}
\examples{

data(presid_2012)
str(presid_2012)
plot(presid_2012)
library(vcd)
vcd::mosaic(t(as.table(as.matrix(presid_2012[1:5,-1]))),
rot_labels=c(0,90,0,0), just_labels  = "right")

}
\keyword{datasets}
