% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get12Bins.R
\name{Get12Bins}
\alias{Get12Bins}
\title{Genetic effects analysis: Twelve bins of expression analysis (method2)}
\usage{
Get12Bins(P1_count, P2_count, F1_count, count_threshold = 5, Pvalue = 0.05)
}
\arguments{
\item{P1_count}{A dataframe. The count data of miRNA from the P1 species. The first column must be the miRNA sequence. Others are listed as the count of miRNA, and each column denotes one biological replicate of the sample.}

\item{P2_count}{A dataframe. Similar with P1_count, the count data of miRNA from the P2 species.}

\item{F1_count}{A dataframe. Similar with P1_count, the count data of miRNA from the F1 species.}

\item{count_threshold}{A numeric. In all samples, there is at least one sample whose count value is more than or equal to count_threshold to be retained. By default, the count value more than or equal to 5 is retained.}

\item{Pvalue}{A numeric. The threshold of significance test among different groups. Default is 0.05.}
}
\value{
A dataframe. The output results contain the P value, log2FoldChange and grouping information for each miRNA expressed in all species (count >= count_threshold). F1_vs_P1(P value: pv11,log2FoldChange: fc11), F1_vs_P2(P value: pv12,log2FoldChange: fc12), P2_vs_P1(P value: pv21,log2FoldChange: fc21)
}
\description{
Genetic effects analysis: Twelve bins of expression analysis (method2)
}
