% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sNPLS_fit.R
\name{cv_fit}
\alias{cv_fit}
\title{Internal function for \code{cv_snpls}}
\usage{
cv_fit(
  xtrain,
  ytrain,
  xval,
  yval,
  ncomp,
  threshold_j = NULL,
  threshold_k = NULL,
  keepJ = NULL,
  keepK = NULL,
  method,
  ...
)
}
\arguments{
\item{xtrain}{A three-way training array}

\item{ytrain}{A response training matrix}

\item{xval}{A three-way test array}

\item{yval}{A response test matrix}

\item{ncomp}{Number of components for the sNPLS model}

\item{threshold_j}{Threshold value on Wj. Scaled between [0, 1)}

\item{threshold_k}{Threshold value on Wk. Scaled between [0, 1)}

\item{keepJ}{Number of variables to keep for each component, ignored if threshold_j is provided}

\item{keepK}{Number of 'times' to keep for each component, ignored if threshold_k is provided}

\item{method}{Select between sNPLS, sNPLS-SR or sNPLS-VIP}

\item{...}{Further arguments passed to sNPLS}
}
\value{
Returns the CV mean squared error
}
\description{
Internal function for \code{cv_snpls}
}
