% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_example.R
\name{gpd_sum_stats}
\alias{gpd_sum_stats}
\title{Generalized Pareto summary statistics}
\usage{
gpd_sum_stats(gpd_data)
}
\arguments{
\item{gpd_data}{A numeric vector containing positive values.}
}
\value{
A list with components
    \item{gpd_data}{A numeric vector. The input vector with any missings
    removed.}
    \item{m}{A numeric scalar. The sample size, i.e., the number of
    non-missing values.}
    \item{xm}{A numeric scalar. The sample maximum}
    \item{sum_gp}{A numeric scalar. The sum of the non-missing sample
    values.}
}
\description{
Calculates summary statistics involved in the Generalized Pareto
log-likelihood.
}
\examples{
\donttest{
# Sample data from a GP(sigma, xi) distribution
gpd_data <- rgpd(m = 100, xi = 0, sigma = 1)
# Calculate summary statistics for use in the log-likelihood
ss <- gpd_sum_stats(gpd_data)
}
}
\seealso{
\code{\link{rgpd}} for simulation from a generalized Pareto
  distribution.
}
