% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{getSample.rtmsBrukerMCFReader}
\alias{getSample.rtmsBrukerMCFReader}
\alias{getBrukerMCFSample}
\title{Extract a sample from a Bruker MCF directory}
\usage{
\method{getSample}{rtmsBrukerMCFReader}(x, peaks, ...)

getBrukerMCFSample(reader, peaks, index)
}
\arguments{
\item{x}{The MCF reader object}

\item{peaks}{A list of peak objects of class \code{rtmsPeak}}

\item{...}{Additional parameters}

\item{reader}{An RTMS reader object of class \code{rtmsBrukerMCFReader}}

\item{index}{A single numeric index specifying which acquisition the sample
set should be extracted from}
}
\value{
An RTMS sample object of class \code{rtmsSample}
}
\description{
Extracts an RTMS sample object (of class \code{rtmsSample}) from a multi-
acquisition Bruker MCF directory opened using an RTMS reader object (of
class \code{rtmsBrukerMCFReader}). A numeric index is used to identify which
acquisition the sample should be extracted from.
}
\section{Functions}{
\itemize{
\item \code{getSample(rtmsBrukerMCFReader)}: The S3 method \code{getSample} for objects
of class \code{rtmsBrukerMCFReader}; calls \code{getBrukerMCFSample}

}}
