% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffReader.R
\name{getWiffShots}
\alias{getWiffShots}
\title{List of Shot Names in a given Wiff File}
\usage{
getWiffShots(wiff)
}
\arguments{
\item{wiff}{A wiff reader object of class \code{rtmsWiffReader}}
}
\value{
A character vector containing the shot names for all shots fired in
each run in a given file.  Note: \emph{not necessarily in the correct order} (see
Details).
}
\description{
List of Shot Names in a given Wiff File
}
\details{
The .wiff file includes these shot names in the order in which they were
input by the user.  They are generally names of wells in a plate, but the
order in which they are given by the user is not necessarily the order in
which the EchoMS will sample them.  By default, the EchoMS will use a more
"efficient" ordering, moving back and forth across the rows of the plate.
So the shot names here may not correlate in order with the measurements
represented by the intensities in the total ion chromatogram.
}
\examples{
wiff <- exampleWiff

shots <- getWiffShots(wiff)
}
