% Generated by roxygen2 (4.0.2): do not edit by hand
\name{head.rpqueue}
\alias{head.rpqueue}
\title{Return the head (front) of an rpqueue}
\usage{
\method{head}{rpqueue}(x, n = 6L, ...)
}
\arguments{
\item{x}{rpqueue to get the head/top of.}

\item{n}{number of elements to get.}

\item{...}{arguments to be passed to or from other methods (ignored).}
}
\value{
an \code{\link{rpqueue}}.
}
\description{
Returns the first \eqn{n} elements of an rpqueue as an rpqueue, or all of the elements
if \code{length(x) < n}.
}
\details{
Runs in \eqn{O(n)} time (in the size of the number of elements requested).
}
\examples{
q <- rpqueue()
q <- insert_back(q, "a")
q <- insert_back(q, "b")
q <- insert_back(q, "c")

qt <- head(q, n = 2)
print(qt)
}
\seealso{
\code{\link{rpqueue}}.
}

