% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fb_suggested_radius.R
\name{get_fb_suggested_radius}
\alias{get_fb_suggested_radius}
\title{Get Suggested Radius}
\usage{
get_fb_suggested_radius(location, distance_unit = "kilometer", version, token)
}
\arguments{
\item{location}{Vector of latitude and longitude (\code{c(lat, lon)}).}

\item{distance_unit}{Either \code{"kilometer"} or "\code{mile}"; defaults to "\code{kilometer}"}

\item{version}{'Facebook Marketing' API version; for example, "v19.0"}

\item{token}{'Facebook Marketing' API token}
}
\value{
Dataframe with suggested radius and distance unit
}
\description{
When targeting around a specific location, returns a suggested radius to reach enough people
}
\details{
For more information, see the \href{https://developers.facebook.com/docs/marketing-api/audiences/reference/targeting-search/#radius}{Facebook documentation here}
}
\examples{
\dontrun{
get_fb_suggested_radius(location = c(38.89831, -77.03658),
                        version  = "v14.0",
                        token    = "TOKEN-HERE")
}
}
