% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfun_rpm_20_04_04.R
\name{in_node}
\alias{in_node}
\title{in_node}
\usage{
in_node(x, node, data)
}
\arguments{
\item{x}{\code{rpms} object}

\item{node}{integer label of the desired end-node.}

\item{data}{dataframe containing the variables used for the recursive 
partitioning.}
}
\value{
vector of indexes for observations in the end-node.
}
\description{
Get index of elements in dataframe that are in the specified 
              end-node of an \code{rpms} object.  A "which" function for end-nodes.
}
\examples{
{
# model mean of retirement account value for households with reported 
# retirment account values > 0 using a binary tree while accounting for 
# clusterd data and sample weights.

s1<- which(CE$IRAX > 0)
r1 <-rpms(IRAX~EDUCA+AGE+BLS_URBN, data = CE[s1,],  weights=~FINLWT21, clusters=~CID) 

# Get summary statistics of CUTENURE for households in end-nodes 7 and 8 of the tree

if(7 \%in\% end_nodes(r1)) 
  summary(CE$CUTENURE[in_node(node=7, r1, data=CE[s1,])])
if(8 \%in\% end_nodes(r1)) 
  summary(CE$CUTENURE[in_node(node=8, r1, data=CE[s1,])])
}

}
