% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_forecast}
\alias{read_forecast}
\title{Read in forecast file}
\usage{
read_forecast(file, pi_width = 95, format = "legacy")
}
\arguments{
\item{file}{Path to csv file containing quantile forecasts}

\item{pi_width}{Width of prediction interval as integer; default \code{95} corresponds to 95\% prediction interval}

\item{format}{Format of the probabilistic format file; must be one of \code{"legacy"} or \code{"hubverse"} (see Details for more information); default is \code{"legacy"}}
}
\value{
A \code{tibble} with the following columns:
\itemize{
\item \strong{location}: Geographic unit such as FIPS code
\item \strong{date}: Date corresponding the forecast horizon
\item \strong{horizon}: Forecast horizon
\item \strong{lower}: Lower limit of the prediction interval for the forecast
\item \strong{point}: Point estimate for the forecast
\item \strong{upper}: Upper limit of the prediction interval for the forecast
}
}
\description{
This function reads a probabilistic ("quantile") forecast csv file and prepares it for the \link{to_signal} function and downstream plausibility analysis. The quantile forecast file can be either a "legacy" or "hubverse" format (see Details for more information). The object returned is a \code{tibble} with summarized forecast data (i.e., prediction interval) for each location and horizon in the original file.
}
\details{
The probabilistic forecast format has been used by multiple forecasting hubs. In general, this format includes one row per combination of quantile, location, target, and horizon. At each row the forecasted value is provided. The specific format, including columns required, has changed over time. This function accommodates the "legacy" as well as more recent "hubverse" formats. For more details on specific columns and see the links in the References.
}
\examples{
## read in example forecast and prep forecast signal (legacy format)
fp <- system.file("extdata/forecast/2022-10-31-SigSci-TSENS.csv", package = "rplanes")
read_forecast(fp)

fp2 <- system.file("extdata/forecast/2023-11-04-SigSci-TSENS.csv", package = "rplanes")
read_forecast(fp2, format = "hubverse")

}
\references{
Hubverse: \url{https://hubdocs.readthedocs.io/en/latest/user-guide/model-output.html}

Legacy: \url{https://github.com/cdcepi/Flusight-forecast-data/tree/master/data-forecasts#forecast-file-format}
}
