% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag_examplesShinylive.R
\name{tag-examplesShinylive}
\alias{tag-examplesShinylive}
\title{Custom \verb{@examplesShinylive} tag.}
\usage{
#' @examplesShinylive${1:# example code (optional)}
}
\description{
This function generates a new "Examples in Shinylive" section in the documentation.
This section contains URL to the application in Shinylive and for HTML outputs: an iframe with the application.
If no code is provided then the code is taken from the following \verb{@examples} or \verb{@examplesIf} tag.
}
\details{
The application code must be executable inside Shinylive. If the application code includes functions from your
package, you must add \verb{library(<package>)} beforehand. For more information, refer to the Decoration section
on how to use and decorate existing examples.

Note: All the packages used in the application code need to be installable in WebR.
See \href{https://docs.r-wasm.org/webr/latest/packages.html}{this article} for more details.
}
\section{Decoration}{


To avoid repetition between the \verb{@examplesShinylive} and \verb{@examples} sections contents,
there are special string literals to be used inside \verb{@examplesShinylive} tag content
that allow you to access the content(s) of the \verb{@examples} or \verb{@examplesIf} tags.
These literals should be used as expressions embraced with \code{{{ }}}, which are then interpolated using
\code{glue::glue_data(..., .open = "{{", .close = "}}")}.

The following keywords are available:
\itemize{
\item \code{"{{ next_example }}"} - (the default if empty) "raw" element of the next example
\item \code{"{{ prev_example }}"} - "raw" element of the previous example
\item \code{"{{ tags_examples }}"} - a list of \verb{@examples} or \verb{@examplesIf} tags
\item \code{"{{ examples }}"} - a list of "raw" elements from \code{tags_examples} list elements
}

This allows you to access and decorate existing example code to create executable application code for Shinylive.
Refer to the examples section for possible use cases.
}

\examples{
# As a part of documentation:

# basic example:
#' (docs)
#' @examplesShinylive
#' @examples
#' (example code)

# using keywords - `{{ next_example }}`:
#' (docs)
#' @examplesShinylive
#' foo <- 1
#' {{ next_example }}
#' bar <- 2
#' @examples
#' (example code)

# using keywords - `{{ prev_example }}`:
#' (docs)
#' bar <- 2
#' @examples
#' (example code)
#' @examplesShinylive
#' foo <- 1
#' {{ prev_example }}

# A typical example would be:
#' (docs)
#' @examplesShinylive
#' library(<package>)
#' interactive <- function() TRUE
#' {{ next_example }}
#' @examples
#' app <- ...
#' if (interactive()) {
#'   shinyApp(app$ui, app$server)
#' }

# multiple apps:
#' (docs)
#' @examplesShinylive
#' @examples
#' (example app 1)
#' @examplesShinylive
#' @examples
#' (example app 2)

# skip parts of example code:
#' (docs)
#' @examples
#' (example code - skipped)
#' @examplesShinylive
#' @examples
#' (example code - included)

# multiple apps with keywords:
#' (docs)
#' @examplesShinylive
#' x <- 1
#' {{ next_example }}
#' @examples
#' (example app 1)
#' @examplesShinylive
#' y <- 1
#' {{ next_example }}
#' @examples
#' (example app 2)

# combining multiple examples:
#' (docs)
#' @examples
#' (app pre-requisites)
#' @examples
#' (example app)
#' @examplesShinylive
#' {{ paste0(examples, collapse = ", ") }}

# identical to the above example but with a different approach:
#' (docs)
#' @examples
#' (app pre-requisites)
#' @examples
#' (example app)
#' @examplesShinylive
#' {{ paste0(lapply(tags_examples, `[[`, "raw"), collapse = ", ") }}
}
