% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asset_route.R
\name{AssetRoute}
\alias{AssetRoute}
\title{Static file serving}
\description{
A class for serving files from the server directly. The \code{AssetRoute} is
fundamentally different than the other routes provided by routr. It is
specific to httpuv and circumvents the standard dispatch entirely (the
request never enters the R process). This makes it extremely fast but also
somewhat limited as you can't pass the request through any middleware.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{at}}{The url path to serve the assets on}

\item{\code{path}}{The path to the file or directory to serve}

\item{\code{use_index}}{Should an \code{index.html} file be served if present when a client requests the folder}

\item{\code{fallthrough}}{Should requests that doesn't match a file enter the request loop or have a 404 response send directly}

\item{\code{html_charset}}{The charset to report when serving html files}

\item{\code{headers}}{A list of headers to add to the response.}

\item{\code{validation}}{An optional validation pattern to compare to the request headers}

\item{\code{except}}{One or more url paths that should be excluded from this route}

\item{\code{name}}{An autogenerated name for the asset route}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AssetRoute-new}{\code{AssetRoute$new()}}
\item \href{#method-AssetRoute-print}{\code{AssetRoute$print()}}
\item \href{#method-AssetRoute-on_attach}{\code{AssetRoute$on_attach()}}
\item \href{#method-AssetRoute-clone}{\code{AssetRoute$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AssetRoute-new"></a>}}
\if{latex}{\out{\hypertarget{method-AssetRoute-new}{}}}
\subsection{Method \code{new()}}{
Create a new AssetRoute
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssetRoute$new(
  at,
  path,
  use_index = TRUE,
  fallthrough = FALSE,
  html_charset = "utf-8",
  headers = list(),
  validation = NULL,
  except = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{at}}{The url path to listen to requests on}

\item{\code{path}}{The path to the file or directory on the file system}

\item{\code{use_index}}{Should an \code{index.html} file be served if present when a
client requests the folder}

\item{\code{fallthrough}}{Should requests that doesn't match a file enter the
request loop or have a 404 response send directly}

\item{\code{html_charset}}{The charset to report when serving html files}

\item{\code{headers}}{A list of headers to add to the response. Will be combined
with the global headers of the app}

\item{\code{validation}}{A string for validating incoming requests. See
\link[httpuv:staticPath]{httpuv::staticPath}}

\item{\code{except}}{One or more url paths that should be excluded from the
route. Requests matching these will enter the standard router dispatch.
The paths are interpreted as subpaths to \code{at}, e.g. the final path to
exclude will be \code{at}+\code{exclude}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AssetRoute-print"></a>}}
\if{latex}{\out{\hypertarget{method-AssetRoute-print}{}}}
\subsection{Method \code{print()}}{
Pretty printing of the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssetRoute$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AssetRoute-on_attach"></a>}}
\if{latex}{\out{\hypertarget{method-AssetRoute-on_attach}{}}}
\subsection{Method \code{on_attach()}}{
Method for use by \code{fiery} when attached as a plugin. Should
not be called directly. This method creates a RouteStack with the asset
route as the single route and then mounts that to the app. For more
flexibility create the RouteStack manually
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssetRoute$on_attach(app, on_error = deprecated(), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The Fire object to attach the router to}

\item{\code{on_error}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} A function for error handling}

\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AssetRoute-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AssetRoute-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AssetRoute$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
