% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolr-functions.R
\name{simdata}
\alias{simdata}
\title{Simulating Survival Times as Functions of a Single Covariate}
\usage{
simdata(nn = 300, const = 365, hr = c(1, 2, 3), hr.linear = 3,
  props = c(1/3, 1/3, 1/3), hazard.func = "step", censoring.rate = 0,
  seed = 1)
}
\arguments{
\item{nn}{Sample size.}

\item{const}{A constant that all of the hazard functions will be divided by.
The bigger it is, the longer the survival times will be. Default is
365.}

\item{hr}{A three-element vector representing the hazards for each of the
groups 1 to 3 when the \code{hazard.func = "step"}.}

\item{hr.linear}{A scalar representing the hazard ratio when the covariate
increases by one unit. This is used with \code{hazard.func = "linear"}.}

\item{props}{A three-element vector representing the proportions of groups
1 to 3 when \code{hazard.func = "step"}.}

\item{hazard.func}{A character that can take either \code{'step'},
\code{'linear'}, or \code{'none'}
to represent a step, linear or no association between the
covariate and survival, respectively.
When it is \code{"step"}, the entire set is divided into 3 groups based
on the covariate with group proportions specified in the \code{props}
argument.}

\item{censoring.rate}{The amount of censoring desired. Default = 0.}

\item{seed}{The random seed used to generate the data. Default = 1.}
}
\value{
A data frame with survival times (times), censoring indicator
  (status), covariate (x), three groups obtained by cutting the covariate
  if \code{hazard.func = "step"} (x3), and censoring rate (censoring.rate).
}
\description{
\code{simdata} is used to simulate survival data from an
  exponential distribution.
  When the hazard function is a step function, we assume 3 underlying groups
  obtained by applying two cutpoints x1 and x2 to the covariate so that group
  1 is \code{x < x1}, group 2 is \code{x >= x1} and \code{x < x2}, and group 3
   is \code{x >= x2}.
  The hazard is a function of the covariate x simulated
  from a uniform distribution from [0, 2]; it can be either
  a linear function, a step function (with three groups), or a constant (in
  which case no association exists between the covariate and survival).
}
\examples{

library(rolr)

#simulate survival with a step hazard function
d1=simdata(nn = 150, hr = c(1, 2, 3), props = c(1/3, 1/3, 1/3),
           hazard.func = "step", censoring.rate = 0)
head(d1)

#simulate survival with a linear hazard function
d2=simdata(nn = 150, hr.linear = 2, hazard.func = "linear", censoring.rate = 0)
head(d2)

#simulate survival with no association with the covariate
d3=simdata(nn = 150, hazard.func = "none", censoring.rate = 0)
head(d3)
}

