% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kobo_form.R
\name{kobo_form}
\alias{kobo_form}
\title{Get a KoboToolbox survey form}
\usage{
kobo_form(x, version)
}
\arguments{
\item{x}{the unique identifier of a specific asset (\code{character}) or
a \code{kobo_asset} object.}

\item{version}{character, the unique identifier of the version of the asset.}
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{name} the name of the survey questions
\item \code{list_name} the name of list of code used for values and labels
\item \code{type} the type of KoboToolbox survey questions
\item \code{label} the label of the questions
\item \code{lang} the languages used in the survey
\item \code{version} the survey version unique identifier
\item \code{choices} a list column with the choices values and labels
\item \code{kuid} the unique identifier of the question
\item \code{qpath} and \code{xpath} the path of the question in JSON/XML
}

You can also have other columns such as \code{relevant}, \code{calculation}, etc. depending on how
you structure for survey form.
}
\description{
Get a KoboToolbox survey form from a \code{kobo_asset} or an asset unique identifier.
}
\examples{
\dontrun{
# Use your own URL and token
kobo_setup(url = "https://kf.kobotoolbox.org/",
           token = "9et1814c285w094f6v9bd629df47a1a0e81x53a0")
# Use your own API asset identifier
uid <- "a9cwEQcbWqWzA5hzkjRUWi"
asset <- kobo_asset(uid)
form <- kobo_form(asset)
}

}
