% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{compute_results_finite}
\alias{compute_results_finite}
\title{Finite-sample test decision for HL1-, HL2-, and MED-tests}
\usage{
compute_results_finite(x, y, alternative, delta, method, n.rep, type)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{a (non-empty) numeric vector of data values.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided", "greater", or "less".}

\item{delta}{a numeric value indicating the true difference in the location
or scale parameter, depending on whether the test should be
performed for a difference in location or in scale.}

\item{method}{a character string specifying how the p-value is computed with
possible values \code{"asymptotic"} for an asymptotic test
based on a normal approximation, \code{"permutation"} for a
permutation test, and \code{"randomization"} for a randomization
test. The permutation test uses all splits of the joint sample
into two samples of sizes \code{m} and \code{n}, while the
randomization test draws \code{n.rep} random splits with
replacement. The values \code{m} and \code{n} denote the
sample sizes.}

\item{n.rep}{an integer value specifying the number of random splits used to
calculate the randomization distribution if \code{method = "randomization"}.}

\item{type}{a character string specifying the desired test statistic. It must
be one of \code{"HL11"}, \code{"HL12", "HL21", "HL22", "MED1"},
and \code{"MED2"}, where \code{"HL1"}, \code{"HL2"} and
\code{"MED"} specify the location estimator and the numbers
\code{1} and \code{2} the scale estimator, see the vignette
(\code{vignette("robnptests")}) for more information.}
}
\value{
A named list containing the following components:
\item{statistic}{the value of the test statistic.}
\item{estimates}{the location estimates for both samples in case of the HL1-
                and the MED-tests. The estimate for the location difference
                in case of the HL2-tests.}
\item{p.value}{the p-value for the test.}
}
\description{
\code{compute_results_finite} is a helper function to compute the test
decision for the HL1-, HL2-, and MED-test when \code{method = "randomization"}
or \code{method = "permutation"}.
}
\keyword{internal}
