% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinRobustNoParallel}
\alias{robinRobustNoParallel}
\title{robinRobustNoParallel}
\usage{
robinRobustNoParallel(
  graph,
  graphRandom,
  method = c("walktrap", "edgeBetweenness", "fastGreedy", "louvain", "spinglass",
    "leadingEigen", "labelProp", "infomap", "optimal", "leiden", "other"),
  ...,
  FUN = NULL,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  type = c("independent", "dependent"),
  verbose = TRUE
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{graphRandom}{The output of random function.}

\item{method}{The clustering method, one of "walktrap", "edgeBetweenness", 
"fastGreedy", "louvain", "spinglass", "leadingEigen", "labelProp", "infomap",
"leiden","optimal".}

\item{...}{other parameter}

\item{FUN}{in case the @method parameter is "other" there is the possibility 
to use a personal function passing its name through this parameter.
The personal parameter has to take as input the @graph and the @weights 
(that can be NULL), and has to return a community object.}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand" all normalized and used as distances.
"nmi" refers to 1- nmi and "adjusted.ran" refers to 1-adjusted.rand.}

\item{type}{The type of robin construction, dependent or independent 
procedure.}

\item{verbose}{flag for verbose output (default as TRUE).}
}
\value{
A list object with two matrices:
- the matrix "Mean" with the means of the procedure for the graph
- the matrix "MeanRandom" with the means of the procedure for the random graph.
}
\description{
This functions implements a procedure to examine the stability 
of the partition recovered by some algorithm against random perturbations 
of the original graph structure.
}
\keyword{internal}
