% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.equivalent.R
\name{is.equivalent}
\alias{is.equivalent}
\title{equivalence class}
\usage{
is.equivalent(x, y, tollerance = .Machine$double.eps^0.5)
}
\arguments{
\item{x}{either a numeric vector, or a data.frame containing such vectors.}

\item{y}{either a numeric vector, or a data.frame containing such vectors.}

\item{tollerance}{numeric >= 0. Differences smaller than tolerance are not considered.}
}
\value{
logical TRUE if the two vectors are from the same equivalence class.
}
\description{
Checks if two vectors or two data frames are from the same equivalence class
}
\examples{

is.equivalent(1:10, 1:10*2)
is.equivalent(1:10, 1:10+1)
data(expenditures)
x <- expenditures
is.equivalent(x, constSum(x))
y <- x
y[1,1] <- x[1,1]+1
is.equivalent(y, constSum(x))

}
\references{
Filzmoser, P., Hron, K., Templ, M. (2018) \emph{Applied Compositional Data Analysis}.
Springer, Cham.
}
\seealso{
\code{\link{all.equal}}
}
\author{
Matthias Templ
}
\keyword{manip}
