% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{as.mfData}
\alias{as.mfData}
\alias{as.mfData.list}
\title{Converting object to \code{mfData} class}
\usage{
as.mfData(x, ...)

\method{as.mfData}{list}(x, ...)
}
\arguments{
\item{x}{a list of univariate functional datasets, provided in form of
\code{fData} objects.}

\item{...}{additional parameters.}
}
\value{
The function returns a \code{mfData} object, obtained starting from
argument \code{x}.
}
\description{
This S3 method provides a way to convert some objects to the class
\code{mfData}, thus obtaining a multivariate functional dataset.
}
\examples{

grid = seq( 0, 1, length.out = 100 )

fD_1 = fData( grid, sin( 2 * pi * grid ) )
fD_2 = fData( grid, cos( 2 * pi * grid ) )

plot( as.mfData( list( fD_1, fD_2 ) ) )

}
