% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{plot.Cov}
\alias{plot.Cov}
\title{Specialized method to plot \code{Cov} objects}
\usage{
\method{plot}{Cov}(x, ...)
}
\arguments{
\item{x}{the covariance or cross-covariance function of class \code{Cov}.}

\item{...}{additional graphical parameters to be used in plotting functions}
}
\description{
This function performs the plot of an object of class \code{Cov}, i.e. a
covariance or cross-covariance function.
}
\details{
It builds above the function \code{graphics::image}, therefore any additional
parameter suitable for \code{graphics::image} will also be suitable as \code{...}
argument to \code{plot.Cov}.
}
\examples{

# Generating a univariate functional dataset
N = 1e2

P = 1e2
t0 = 0
t1 = 1

time_grid = seq( t0, t1, length.out = P )

Cov = exp_cov_function( time_grid, alpha = 0.3, beta = 0.4 )

D1 = generate_gauss_fdata( N, centerline = sin( 2 * pi * time_grid ), Cov = Cov )

fD1 = fData( time_grid, D1 )

# Computing the covariance function of fD1

plot( cov_fun( fD1 ), main = 'Covariance function', xlab = 'time', ylab = 'time' )

}
\seealso{
\code{\link{cov_fun}}
}
