% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myTarGetGoalsStats.R
\name{myTarGetGoalsStats}
\alias{myTarGetGoalsStats}
\title{Get Goal Statistics from 'MyTarget'}
\usage{
myTarGetGoalsStats(
  date_from = Sys.Date() - 7,
  date_to = Sys.Date(),
  object_type = "campaigns",
  object_id = NULL,
  attribution = c("impression", "conversion"),
  conversion_type = c("postview", "postclick", "total"),
  auth = NULL,
  login = getOption("rmytarget.login"),
  token_path = myTarTokenPath()
)
}
\arguments{
\item{date_from}{Start date}

\item{date_to}{End date}

\item{object_type}{API object type, character value, one of campaigns, banners, users.}

\item{object_id}{ID of API object (id campaign or any object).}

\item{attribution}{Attributing by event time or impression time. Available options: conversion, impression, default.}

\item{conversion_type}{Conversion type: postclick - postclick, postview - postview, total - total.}

\item{auth}{MyTarget Autherization R object. See \code{\link{myTarAuth}}}

\item{login}{Path to directory where you save credential data}

\item{token_path}{Your login, or client name in MyTarget account}
}
\value{
data frame with goal statics
}
\description{
Get Goal Statistics from 'MyTarget'
}
\seealso{
\href{https://target.my.com/adv/api-marketing/doc/stat-v2#goals}{API Documentation}
}
