% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_columns.R
\name{def_columns}
\alias{def_columns}
\title{Define Macrostrat columns}
\usage{
def_columns(
  column_id = NULL,
  column_group_id = NULL,
  column_name = NULL,
  project_id = NULL,
  status = NULL
)
}
\arguments{
\item{column_id}{\code{integer}. The unique identification number(s) of the
desired column(s) to return a definition for.}

\item{column_group_id}{\code{integer}. The unique identification number(s) of
the desired column group(s) to return a definition for.}

\item{column_name}{\code{character}. The name of the desired column to return
a definition for.}

\item{project_id}{\code{integer}. The unique identification number(s) of the
desired Macrostrat project(s) to return a definition for.}

\item{status}{\code{character}. The status of the column to return a
definition for. Either "active", "in process", or "obsolete".}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{col_id}: The unique identification number for the column.
\item \code{col_group_id}: The unique identification number of the group to
which the column belongs.
\item \code{col_name}: The name of the column.
\item \code{lat}: Latitude of the centroid of the column.
\item \code{lng}: Longitude of the centroid of the column.
\item \code{col_area}: Area of the Macrostrat column,
in km\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
\item \code{max_thick}: Maximum unit thickness in meters.
\item \code{ref_id}: The unique identification number for the reference
associated with the column.
\item \code{status}: Indicates the current status of the column (values are
'active', 'in process', and 'obsolete').
\item \code{t_units}: Total number of Macrostrat units contained within the
column.
\item \code{project_id}: The unique identification number for the column's
project. Corresponds to general geographic region.
\item \code{notes}: Column specific notes.
}
}
\description{
A function to retrieve the definitions for Macrostrat columns.
By default, all definitions are returned.
}
\section{Developer(s)}{

William Gearty
}

\section{Reviewer(s)}{

Christopher D. Dean
}

\examples{
\donttest{
# Return all column definitions
ex1 <- def_columns()
# Return subsets of column definitions
ex2 <- def_columns(column_group_id = 17)
ex3 <- def_columns(column_id = c(22,24))
ex4 <- def_columns(column_name = "Eastern Kentucky")
}
}
\seealso{
Macrostrat data entities:
\code{\link{get_age_model}()},
\code{\link{get_columns}()},
\code{\link{get_sections}()},
\code{\link{get_units}()}
}
\concept{macrostrat}
