% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/travellingsalespersonproblem.R
\name{TravelingSalesperson}
\alias{TravelingSalesperson}
\alias{TravellingSalesperson}
\title{Solver for Traveling Salesperson Problem}
\usage{
TravelingSalesperson(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999,
  algorithm = "Christofides"
)

TravellingSalesperson(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999,
  algorithm = "Christofides"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of a graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{defaultEdgeWeight}{The default edge weight if an edge is not-specified
(default value 999999)}

\item{algorithm}{Choices of algorithm include "Christofides", "Greedy",
"Insertion", "NearestNeighbor", and "Opt2". "Christofides" is the default.}
}
\value{
A named list with 1) "node_order": the vector of visited nodes in
  order, and 2) "cost": the total tour cost.
}
\description{
Finds approximations for the travelling salesperson problem using
approximation algorithms on graphs. NOTE: LEMON's TSP uses a
complete graph in its backend, so expect less performance on sparse graphs.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00618.html}.
}
