% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landfireAPI.R
\name{landfireAPI}
\alias{landfireAPI}
\title{Depreciated: Call the LANDFIRE Product Service (LFPS) API}
\usage{
landfireAPI(
  products,
  aoi,
  projection = NULL,
  resolution = NULL,
  edit_rule = NULL,
  edit_mask = NULL,
  path = NULL,
  max_time = 10000,
  method = "curl",
  verbose = TRUE
)
}
\arguments{
\item{products}{Product names as character vector
(see: Products Table)}

\item{aoi}{Area of interest as character or numeric vector defined by
latitude and longitude in decimal degrees in WGS84 and ordered
\code{xmin}, \code{ymin}, \code{xmax}, \code{ymax} or a LANDFIRE map zone.}

\item{projection}{Optional. A numeric value of the WKID for the output projection
Default is a localized Albers projection.}

\item{resolution}{Optional. A numeric value between 30-9999 specifying the
resample resolution in meters. Default is 30m.}

\item{edit_rule}{Optional. A list of character vectors ordered "operator class"
"product", "operator", "value". Limited to fuel theme products only.
(see: LFPS Guide)}

\item{edit_mask}{Optional. \strong{Not currently functional}}

\item{path}{Path to \code{.zip} directory. Passed to \code{\link[utils:download.file]{utils::download.file()}}.
If NULL, a temporary directory is created.}

\item{max_time}{Maximum time, in seconds, to wait for job to be completed.}

\item{method}{Passed to \code{\link[utils:download.file]{utils::download.file()}}. See \code{?download.file} or
use "none" to skip download and use \code{landfire_vsi()}}

\item{verbose}{If FALSE suppress all status messages}
}
\value{
Returns a \code{landfire_api} object with named elements:
\itemize{
\item \code{request} - list with elements \code{query}, \code{date}, \code{url}, \code{job_id},\code{dwl_url}
\item \code{content} - Informative messages passed from API
\item \code{response} - Full response
\item \code{status} - Final API status, one of "Failed", "Succeeded", or "Timed out"
\item \code{path} - path to save directory
}
}
\description{
Superseded: \code{landfireAPI()} is no longer supported due to updates to the
LFPS API. Use \code{landfireAPIv2()} instead.

\code{landfireAPI} downloads LANDFIRE data by calling the LFPS API
}
\examples{
\dontrun{
products <-  c("ASP2020", "ELEV2020", "230CC")
aoi <- c("-123.7835", "41.7534", "-123.6352", "41.8042")
projection <- 6414
resolution <- 90
edit_rule <- list(c("condition","ELEV2020","lt",500), c("change", "230CC", "st", 181))
save_file <- tempfile(fileext = ".zip")
resp <- landfireAPI(products, aoi, projection, resolution, edit_rule = edit_rule, path = save_file)
}
}
