% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.rjuliabugs}
\alias{summary.rjuliabugs}
\title{Summary Method for JuliaBUGS Sampler Output}
\usage{
\method{summary}{rjuliabugs}(object, ...)
}
\arguments{
\item{object}{An object of class \code{rjuliabugs} containing a reference to a Markov Chain Monte Carlo (MCMC) sampler from Julia.}

\item{...}{Additional optional arguments. Supported options:
\itemize{
\item \code{digits}: Integer. Number of significant digits to display. Default: 4.
\item \code{n_display}: Integer. Number of rows of summary statistics to show. Default: 10.
\item \code{get_summary}: Logical. If \code{TRUE}, returns summary statistics in the output list. Default: \code{FALSE}.
\item \code{get_quantiles}: Logical. If \code{TRUE}, returns quantiles in the output list. Default: \code{FALSE}.
\item \code{julia_summary_only}: Logical. If \code{TRUE}, displays the Julia summary directly and returns \code{NULL} invisibly. Default: \code{FALSE}.
}}
}
\value{
If \code{julia_summary_only = TRUE}, no value is called for the print message.
Otherwise, returns a list possibly containing:
\itemize{
\item \code{summary}: Data frame of summary statistics (if \code{get_summary = TRUE}).
\item \code{quantiles}: Data frame of quantiles (if \code{get_quantiles = TRUE}).
}
}
\description{
Provides a summary of the results from a JuliaBUGS sampler object, including Markov Chain Monte Carlo (MCMC) settings,
summary statistics, and optionally quantiles.
}
\details{
This method wraps Julia's \code{MCMCChains.summarystats} and \code{MCMCChains.quantile} to extract and display
results in R using the \code{JuliaCall} interface. It also extracts key MCMC settings like number of chains,
iterations, and samples per chain. The printed summary is truncated to \code{n_display} rows.
}
