% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_area.R
\name{plot_area}
\alias{plot_area}
\title{Plot an area diagram of probabilities or frequencies.}
\usage{
plot_area(
  prev = num$prev,
  sens = num$sens,
  mirt = NA,
  spec = num$spec,
  fart = NA,
  N = num$N,
  by = "cddc",
  p_split = "v",
  area = "sq",
  scale = "p",
  round = TRUE,
  sample = FALSE,
  sum_w = 0.1,
  gaps = c(NA, NA),
  f_lbl = "num",
  f_lbl_sep = NA,
  f_lbl_sum = "num",
  f_lbl_hd = "nam",
  f_lwd = 0,
  p_lbl = NA,
  arr_c = -3,
  col_p = c(grey(0.15, 0.99), "yellow", "yellow"),
  brd_dis = 0.06,
  lbl_txt = txt,
  main = txt$scen_lbl,
  sub = "type",
  title_lbl = NULL,
  cex_lbl = 0.9,
  cex_p_lbl = NA,
  col_pal = pal,
  mar_notes = FALSE,
  ...
)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{N}{The number of individuals in the population.
A suitable value of \code{\link{N}} is computed, if not provided.
Note: \code{\link{N}} is not represented in the plot,
but used for computing frequency information \code{\link{freq}}
from current probabilities \code{\link{prob}}.}

\item{by}{A character code specifying 2 perspectives that split the population into subsets,
with 6 options:
  \enumerate{
  \item \code{"cddc"}: by condition (cd) and by decision (dc) (default);
  \item \code{"cdac"}: by condition (cd) and by accuracy (ac);
  \item \code{"dccd"}: by decision (dc) and by condition (cd);
  \item \code{"dcac"}: by decision (dc) and by accuracy (ac);
  \item \code{"accd"}: by accuracy (ac) and by condition (cd);
  \item \code{"acdc"}: by accuracy (ac) and by decision (dc).
  }}

\item{p_split}{Primary perspective for population split,
with 2 options:
  \enumerate{
  \item \code{"v"}: vertical (default);
  \item \code{"h"}: horizontal.
  }}

\item{area}{A character code specifying the shape of the main area,
with 2 options:
  \enumerate{
  \item \code{"sq"}: main area is scaled to a square (default);
  \item \code{"no"}: no scaling (rectangular area fills plot size).
  }}

\item{scale}{Scale probabilities and corresponding area dimensions either by
exact probability or by (rounded or non-rounded) frequency, with 2 options:
  \enumerate{
  \item \code{"p"}: scale main area dimensions by exact probability (default);
  \item \code{"f"}: re-compute probabilities from (rounded or non-rounded) frequencies
  and scale main area dimensions by their frequency.
  }
 Note: \code{scale} setting matters for the display of probability values and for
 area plots with small population sizes \code{\link{N}} when \code{round = TRUE}.}

\item{round}{A Boolean option specifying whether computed frequencies
are rounded to integers. Default: \code{round = TRUE}.}

\item{sample}{Boolean value that determines whether frequency values
are sampled from \code{N}, given the probability values of
\code{prev}, \code{sens}, and \code{spec}.
Default: \code{sample = FALSE}.}

\item{sum_w}{Border width of 2 perspective summaries
(on top and left borders) of main area as a proportion of area size
(i.e., in range \code{0 <= sum_w <= 1}).
Default: \code{sum_w = .10}.
Setting \code{sum_w = 0}, \code{NA}, or \code{NULL} removes summaries;
setting \code{sum_w = 1} scales summaries to same size as main areas.}

\item{gaps}{Size of gaps (as binary numeric vector) specifying
the width of vertical and horizontal gaps as proportions of area size.
Defaults: \code{gaps = c(.02, .00)} for \code{p_split = "v"} and
\code{gaps = c(.00, .02)} for \code{p_split = "h"}.}

\item{f_lbl}{Type of label for showing frequency values in 4 main areas,
with 6 options:
  \enumerate{
  \item \code{"def"}: abbreviated names and frequency values;
  \item \code{"abb"}: abbreviated frequency names only (as specified in code);
  \item \code{"nam"}: names only (as specified in \code{lbl_txt = txt});
  \item \code{"num"}: numeric frequency values only (default);
  \item \code{"namnum"}: names (as specified in \code{lbl_txt = txt}) and numeric values;
  \item \code{"no"}: no frequency labels (same for \code{f_lbl = NA} or \code{NULL}).
  }}

\item{f_lbl_sep}{Label separator for main frequencies
(used for \code{f_lbl = "def" OR "namnum"}).
Use \code{f_lbl_sep = ":\n"} to add a line break between name and numeric value.
Default: \code{f_lbl_sep = NA} (set to \code{" = "} or \code{":\n"} based on \code{f_lbl}).}

\item{f_lbl_sum}{Type of label for showing frequency values in summary cells,
with same 6 options as \code{f_lbl} (above).
Default: \code{f_lbl_sum = "num"}: numeric values only.}

\item{f_lbl_hd}{Type of label for showing frequency values in header,
with same 6 options as \code{f_lbl} (above).
Default: \code{f_lbl_hd = "nam"}: names only (as specified in \code{lbl_txt = txt}).}

\item{f_lwd}{Line width of areas.
Default: \code{f_lwd = 0}.}

\item{p_lbl}{Type of label for showing 3 key probability links and values,
with 7 options:
  \enumerate{
  \item \code{"def"}: show links and abbreviated names and probability values;
  \item \code{"abb"}: show links and abbreviated probability names;
  \item \code{"nam"}: show links and probability names (as specified in code);
  \item \code{"num"}: show links and numeric probability values;
  \item \code{"namnum"}: show links with names and numeric probability values;
  \item \code{"no"}: show links with no labels;
  \item \code{NA}: show no labels or links (same for \code{p_lbl = NULL}, default).
  }}

\item{arr_c}{Arrow code for symbols at ends of probability links
(as a numeric value \code{-3 <= arr_c <= +6}),
with the following options:
  \itemize{
  \item \code{-1} to \code{-3}: points at one/other/both end/s;
  \item \code{0}: no symbols;
  \item \code{+1} to \code{+3}: V-arrow at one/other/both end/s;
  \item \code{+4} to \code{+6}: T-arrow at one/other/both end/s.
}
Default: \code{arr_c = -3} (points at both ends).}

\item{col_p}{Colors of probability links (as vector of 3 colors).
Default: \code{col_p = c(grey(.15, .99), "yellow", "yellow")}.
(Also consider: "black", "cornsilk", "whitesmoke").}

\item{brd_dis}{Distance of probability links from area border
(as proportion of area width).
Default: \code{brd_dis = .06}.
Note: Adjust to avoid overlapping labels.
Negative values show links outside of main area.}

\item{lbl_txt}{Default label set for text elements.
Default: \code{lbl_txt = \link{txt}}.}

\item{main}{Text label for main plot title.
Default: \code{main = txt$scen_lbl}.}

\item{sub}{Text label for plot subtitle (on 2nd line).
Default: \code{sub = "type"} shows information on current plot type.}

\item{title_lbl}{\strong{Deprecated} text label for current plot title.
Replaced by \code{main}.}

\item{cex_lbl}{Scaling factor for text labels (frequencies and headers).
Default: \code{cex_lbl = .90}.}

\item{cex_p_lbl}{Scaling factor for text labels (probabilities).
Default: \code{cex_p_lbl = cex_lbl - .05}.}

\item{col_pal}{Color palette.
Default: \code{col_pal = \link{pal}}.}

\item{mar_notes}{Boolean option for showing margin notes.
Default: \code{mar_notes = FALSE}.}

\item{...}{Other (graphical) parameters.}
}
\value{
Nothing (NULL).
}
\description{
\code{plot_area} assigns the total probability
or population frequency to an area (square or rectangle)
and shows the probability or frequency of
4 classification cases (\code{\link{hi}}, \code{\link{mi}},
\code{\link{fa}}, \code{\link{cr}})
as relative proportions of this area.
}
\details{
\code{plot_area} computes probabilities \code{\link{prob}}
and frequencies \code{\link{freq}}
from a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}})
or existing frequency information \code{\link{freq}}
and a population size of \code{\link{N}} individuals.

\code{plot_area} generalizes and replaces \code{\link{plot_mosaic}}.
by removing the dependency on the R packages \code{vcd} and \code{grid}
and providing many additional options.
}
\examples{
## Basics:
# (1) Using global prob and freq values:
plot_area()  # default area plot,
# same as:
# plot_area(by = "cddc", p_split = "v", area = "sq", scale = "p")

# (2) Providing values:
plot_area(prev = .5, sens = 4/5, spec = 3/5, N = 10)

# (3) Rounding and sampling:
plot_area(N = 100, prev = 1/3, sens = 2/3, spec = 6/7, area = "hr", round = FALSE)
plot_area(N = 100, prev = 1/3, sens = 2/3, spec = 6/7, area = "hr", sample = TRUE, scale = "freq")

# (4) Custom colors and text:
plot_area(prev = .2, sens = 4/5, spec = 3/5, N = 10,
          by = "cddc", p_split = "v", scale = "p",
          main = "Custom text and color:",
          lbl_txt = txt_org, f_lbl = "namnum",
          f_lbl_sep = ":\n", f_lwd = 2, col_pal = pal_rgb)

## Versions:
## by x p_split (= [3 x 2 x 2] = 12 versions):
plot_area(by = "cddc", p_split = "v")  # v01 (see v07)
plot_area(by = "cdac", p_split = "v")  # v02 (see v11)
# plot_area(by = "cddc", p_split = "h")  # v03 (see v05)
# plot_area(by = "cdac", p_split = "h")  # v04 (see v09)

# plot_area(by = "dccd", p_split = "v")  # v05 (is v03 rotated)
plot_area(by = "dcac", p_split = "v")  # v06 (see v12)
# plot_area(by = "dccd", p_split = "h")  # v07 (is v01 rotated)
# plot_area(by = "dcac", p_split = "h")  # v08 (see v10)

# plot_area(by = "accd", p_split = "v")  # v09 (is v04 rotated)
# plot_area(by = "acdc", p_split = "v")  # v10 (is v08 rotated)
# plot_area(by = "accd", p_split = "h")  # v11 (is v02 rotated)
# plot_area(by = "acdc", p_split = "h")  # v12 (is v06 rotated)

## Options:
# area:
plot_area(area = "sq")  # main area as square (by scaling x-values)
plot_area(area = "no")  # rectangular main area (using full plotting region)

# scale (matters for small N):
plot_area(N = 5, prev = .5, sens = .8, spec = .6,
          by = "cddc", p_split = "v", scale = "p", p_lbl = "def")  # scaled by prob (default)
plot_area(N = 5, prev = .5, sens = .8, spec = .6,
          by = "cddc", p_split = "v", scale = "f", p_lbl = "def")  # scaled by freq (for small N)
plot_area(N = 4, prev = .4, sens = .8, spec = .6,
          by = "cdac", p_split = "h", scale = "p", p_lbl = "def")  # scaled by prob (default)
plot_area(N = 4, prev = .4, sens = .8, spec = .6,
          by = "cdac", p_split = "h", scale = "f", p_lbl = "def")  # scaled by freq (for small N)

# gaps (sensible range: 0--.10):
plot_area(gaps = NA)             # default gaps (based on p_split)
plot_area(gaps = c(0, 0))        # no gaps
# plot_area(gaps = c(.05, .01))  # v_gap > h_gap

# freq labels:
plot_area(f_lbl = "def", f_lbl_sep = " = ")  # default
plot_area(f_lbl = NA)       # NA/NULL: no freq labels (in main area & top/left boxes)
plot_area(f_lbl = "abb")    # abbreviated name (i.e., variable name)
# plot_area(f_lbl = "nam")  # only freq name
# plot_area(f_lbl = "num")  # only freq number
plot_area(f_lbl = "namnum", f_lbl_sep = ":\n", cex_lbl = .75)  # explicit & smaller

# prob labels:
plot_area(p_lbl = NA)      # default: no prob labels, no links
# plot_area(p_lbl = "no")  # show links, but no labels
plot_area(p_lbl = "namnum", cex_lbl = .70)  # explicit & smaller labels

# prob arrows:
plot_area(arr_c = +3, p_lbl = "def", f_lbl = NA)  # V-shape arrows
# plot_area(arr_c = +6, p_lbl = "def", f_lbl = NA)  # T-shape arrows
# plot_area(arr_c = +6, p_lbl = "def", f_lbl = NA,
#           brd_dis = -.02, col_p = c("black")) # adjust arrow type/position

# f_lwd:
plot_area(f_lwd =  3)    # thicker lines
plot_area(f_lwd = .5)    # thinner lines
# plot_area(f_lwd =  0)  # no lines (if f_lwd = 0/NULL/NA: lty = 0)

# sum_w:
# plot_area(sum_w = .10)  # default (showing top and left freq panels & labels)
plot_area(sum_w =  0)   # remove top and left freq panels
plot_area(sum_w =  1,         # top and left freq panels scaled to size of main areas
          col_pal = pal_org)  # custom colors

## Plain and suggested plot versions:
plot_area(sum_w = 0, f_lbl = "abb", p_lbl = NA)  # no compound indicators (on top/left)
plot_area(gap = c(0, 0), sum_w = 0, f_lbl = "num", p_lbl = "num",  # no gaps, numeric labels
          f_lwd = .5, col_pal = pal_bw, main = "Black-and-white")  # b+w print version
# plot_area(f_lbl = "nam", p_lbl = NA, col_pal = pal_mod)  # plot with freq labels
plot_area(f_lbl = "num", p_lbl = NA, col_pal = pal_rgb)  # no borders around boxes

}
\seealso{
\code{\link{plot_mosaic}} for older (obsolete) version;
\code{\link{plot_tab}} for plotting table (without scaling area dimensions);
\code{\link{pal}} contains current color settings;
\code{\link{txt}} contains current text settings.

Other visualization functions: 
\code{\link{plot.riskyr}()},
\code{\link{plot_bar}()},
\code{\link{plot_crisk}()},
\code{\link{plot_curve}()},
\code{\link{plot_fnet}()},
\code{\link{plot_icons}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_plane}()},
\code{\link{plot_prism}()},
\code{\link{plot_tab}()},
\code{\link{plot_tree}()}
}
\concept{visualization functions}
