% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{ttest}
\alias{ttest}
\alias{ttest.do}
\alias{print.ttest}
\alias{ttest.default}
\title{T-test with Improved Layout}
\usage{
ttest(
  var1,
  var2 = NA,
  by = NA,
  geom = FALSE,
  null.hypoth = 0,
  alternative = "two.sided",
  var.eq = FALSE,
  conf.level = 0.95,
  matched = FALSE,
  more.digits = 0
)
}
\arguments{
\item{var1}{a (non-empty) numeric vector of
data values.}

\item{var2}{an optional (non-empty) numeric
vector of data.}

\item{by}{a variable of equal length to
that of \code{var1} with two outcomes. This will be used to define strata
for a t-test on \code{var1}.}

\item{geom}{a logical indicating whether the geometric mean should be
calculated and displayed.}

\item{null.hypoth}{a number specifying the
null hypothesis for the mean (or difference in means if performing a
two-sample test). Defaults to zero.}

\item{alternative}{a string: one of
\code{"less"}, \code{"two.sided"}, or \code{"greater"} specifying the form
of the test. Defaults to a two-sided test.}

\item{var.eq}{a logical value, either
\code{TRUE} or \code{FALSE} (default), specifying whether or not equal
variances should be presumed in a two-sample t-test. Also controls robust
standard errors.}

\item{conf.level}{confidence level of the
test. Defaults to 0.95.}

\item{matched}{a logical value, either
\code{TRUE} or \code{FALSE}, indicating whether or not the variables of a
two-sample t-test are matched. Variables must be of equal length.}

\item{more.digits}{a numeric value
specifying whether or not to display more or fewer digits in the output.
Non-integers are automatically rounded down.}
}
\value{
a list of class \code{ttest}. The print method lays out the information in an easy-to-read
format. 
\describe{
\item{tab}{A formatted table of descriptive and inferential statistics (total number of observations,
number of missing observations, mean, standard error of the mean estimate, standard deviation), 
along with a confidence interval for the mean.}
\item{df}{Degrees of freedom for the t-test.}
\item{p}{P-value for the t-test.}
\item{tstat}{Test statistic for the t-test.}
\item{var1}{The user-supplied first data vector. }
\item{var2}{The user-supplied second data vector. }
\item{by}{The user-supplied stratification variable.}
\item{par}{A vector of information about the type of test (null hypothesis, alternative hypothesis, etc.)}
\item{geo}{A formatted table of descriptive and inferential statistics for the geometric mean.}
\item{call}{The call made to the \code{ttest} function.}
}
}
\description{
Performs a one- or two-sample t-test using data. In the two-sample case, the user can specify
whether or not observations are matched, and whether or not equal variances
should be presumed.
}
\details{
Missing values must be given by \code{NA} to be recognized as missing values.
}
\examples{

# Read in data set
data(psa)
attach(psa)

# Perform t-test
ttest(pretxpsa, null.hypoth = 100, alternative = "greater", more.digits = 1)

# Define new binary variable as indicator
# of whether or not bss was worst possible
bssworst <- bss
bssworst[bss == 1] <- 0
bssworst[bss == 2] <- 0
bssworst[bss == 3] <- 1

# Perform t-test allowing for unequal
# variances between strata -#
ttest(pretxpsa, by = bssworst)

# Perform matched t-test
ttest(pretxpsa, nadirpsa, matched = TRUE, conf.level = 99/100, more.digits = 1)


}
\seealso{
\code{\link[stats]{t.test}}
}
