% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_fields.R
\name{riemann}
\alias{riemann}
\title{Riemann curvature tensor}
\usage{
riemann(g)
}
\arguments{
\item{g}{A covariant metric tensor, a "metric_field" object. See \code{\link[=metric_field]{metric_field()}}
to create a new metric tensor, or use predefined metrics,
e.g. \code{\link[=g_eucl_cart]{g_eucl_cart()}}.}
}
\value{
Returns the covariant Riemann curvature tensor \eqn{R_{ijkl}}
as rank 4 \code{\link[=array]{array()}}.
}
\description{
Provides the covariant Riemann curvature tensor \eqn{R_{ijkl}}.
}
\examples{
riemann(g_eucl_sph(3))
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Riemann_curvature_tensor}{Riemann curvature tensor}

Other geometric tensors: 
\code{\link{christoffel}()},
\code{\link{ricci}()},
\code{\link{ricci_sc}()}
}
\concept{geom_tensors}
\concept{geometric tensors}
