% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{devmode}
\alias{devmode}
\title{Development mode}
\usage{
devmode(
  build_sass = TRUE,
  build_js = TRUE,
  run_r_unit_tests = TRUE,
  auto_test_r_args = list(reporter = NULL, filter = NULL, hash = TRUE),
  ...
)
}
\arguments{
\item{build_sass}{Boolean. Rebuild Sass automatically in the background?}

\item{build_js}{Boolean. Rebuild JavaScript automatically in the background?}

\item{run_r_unit_tests}{Boolean. Run R unit tests automatically in the background?}

\item{auto_test_r_args}{List. Additional arguments passed to \code{auto_test_r()}.}

\item{...}{Additional arguments passed to \code{shiny::runApp()}.}
}
\value{
None. This function is called for side effects.
}
\description{
Run application in development mode with automatic rebuilding and reloading.
}
\details{
This function will launch the Shiny app in
\href{https://shiny.posit.co/r/reference/shiny/latest/devmode.html}{development mode}
(as if \code{options(shiny.devmode = TRUE)} was set).
The app will be automatically reloaded whenever the sources change.

Additionally, Rhino will automatically rebuild JavaScript and Sass in the background
and run R unit tests with the \code{auto_test_r()} function.
Please note that this feature requires Node.js.
}
