% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minmaxDTM_get.R
\name{minmaxDTM_get}
\alias{minmaxDTM_get}
\title{Get minimum and maximum elevation for a given polygon}
\usage{
minmaxDTM_get(polygon)
}
\arguments{
\item{polygon}{the polygon layer with only one object (area less than 10 ha),
the larger the polygon area, the lower DTM resolution,
the input coordinate system must be EPSG:2180}
}
\value{
a data frame with vector points and min/max terrain elevation
(EPSG:2180)
}
\description{
Get minimum and maximum elevation for a given polygon
}
\examples{
\dontrun{
library(sf)
polygon_path = system.file("datasets/search_area.gpkg", package = "rgugik")
polygon = read_sf(polygon_path)
minmax = minmaxDTM_get(polygon)
}
}
