% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgsp_asym1.R
\name{rgsp_asym1}
\alias{rgsp_asym1}
\alias{rgsp_asym1.default}
\title{Repetitive Group Sampling Plan Based on Cpk under asymmetric Case 1}
\usage{
\method{rgsp_asym1}{default}(.p1, .p2, .alpha, .beta, .nums, .rep)
}
\arguments{
\item{.p1}{Acceptable Quality Level (AQL) Probability}

\item{.p2}{Limiting Quality Level (LQL) Probability}

\item{.alpha}{Producer's alpha-risk}

\item{.beta}{Consumer's beta-risk}

\item{.nums}{Number of samples with replacement at each iteration}

\item{.rep}{Number of iterations}
}
\value{
Sample Number and Average Sample Number
}
\description{
Calculates Sample Number and Average Sample Number for Repetitive Group Sampling Plan based on Cpk under asymmetric case 1 as given in Aslam et al. (2013)
}
\examples{

rgsp_asym1(
    .p1     = 0.001
  , .p2     = 0.003
  , .alpha  = 0.050
  , .beta   = 0.100
  , .nums   = 10000
  , .rep    = 10 # 1000
)


}
\references{
Aslam, M., Wu, C., Jun, C., Azam, M. and Itay, N. (2013).
 Developing a variables repetitive group sampling plan based on process capability index Cpk with unknown mean and variance.
 \emph{Journal of Statistical Computation and Simulation}.
 \strong{83}(8):1507-1517. (\href{https://www.tandfonline.com/doi/abs/10.1080/00949655.2012.663374}{https://www.tandfonline.com/doi/abs/10.1080/00949655.2012.663374})
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Muhammad Aslam (\email{aslam_ravian@hotmail.com})
         \item Sami Ullah (\email{samiullahuos@gmail.com})
         \item Muhammad Kashif (\email{mkashif@uaf.edu.pk})
         }
}
