% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_graph6.R
\name{from_graph6}
\alias{from_graph6}
\alias{adjacency_from_graph6}
\alias{igraph_from_graph6}
\alias{network_from_graph6}
\title{Functions parsing 'graph6' symbols}
\usage{
adjacency_from_graph6(g6)

igraph_from_graph6(g6, ...)

network_from_graph6(g6, ...)
}
\arguments{
\item{g6}{character vector of 'graph6' symbols}

\item{...}{other arguments, see Details.}
}
\value{
The returned object is:

\itemize{
\item for \code{\link[=adjacency_from_graph6]{adjacency_from_graph6()}}, a list of the same length as
its input of square symmetric adjacency matrices.
}

\itemize{
\item for \code{\link[=igraph_from_graph6]{igraph_from_graph6()}}, a list of 'igraph' objects
}

\itemize{
\item for \code{\link[=network_from_graph6]{network_from_graph6()}}, a list of network objects
}
}
\description{
These functions take a vector of 'graph6' symbols and return a
list of other types of objects:

\itemize{
\item \code{\link[=adjacency_from_graph6]{adjacency_from_graph6()}} creates adjacency matrices
}

\itemize{
\item \code{\link[=igraph_from_graph6]{igraph_from_graph6()}} creates 'igraph' objects. Requires
package \pkg{igraph} to be installed.
}

\itemize{
\item \code{\link[=network_from_graph6]{network_from_graph6()}} creates network objects. Requires
package \pkg{network} to be installed.
}
}
\details{
For \code{\link[=igraph_from_graph6]{igraph_from_graph6()}} additional arguments are passed to
\code{\link[igraph:graph_from_adjacency_matrix]{igraph::graph_from_adjacency_matrix()}}

For \code{\link[=network_from_graph6]{network_from_graph6()}} additional arguments are passed to
\code{\link[network:network]{network::as.network()}}
}
\examples{
A <- matrix(c(0,1,0,1,
              1,0,1,0,
              0,1,0,1,
              1,0,1,0), 4, 4, byrow = TRUE)
g6 <- as_graph6(A)

# To adjacency matrix ------------------------------------------------------
adjacency_from_graph6(g6)

# To igraph objects --------------------------------------------------------
if(requireNamespace("igraph", quietly=TRUE)) {
  igraph_from_graph6(g6)
}

# To network objects -------------------------------------------------------
if(requireNamespace("network", quietly=TRUE)) {
  network_from_graph6(g6)
}
}
\seealso{
\code{\link[=as_graph6]{as_graph6()}} for saving objects as 'graph6' symbols.
}
