% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{check.dpl.edges}
\alias{check.dpl.edges}
\title{Check (and count) duplicated edges}
\usage{
check.dpl.edges(edges, undirected = FALSE, order.edgelist = TRUE)
}
\arguments{
\item{edges}{A matrix or data frame structured as a list of edges}

\item{undirected}{Declares if the net is directed or not (does de difference)}

\item{order.edgelist}{Whether to sort the resulting matrix or not}
}
\value{
A three column \code{data.frame} with colnames \dQuote{source},
\dQuote{target} \dQuote{reps}.
}
\description{
Looks for duplicated edges and reports the number of instances of them.
}
\details{
\code{check.dpl.edges} looks for duplicated edges reporting duplicates and
counting how many times each edge is duplicated.

For every group of duplicated edges only one will be accounted to report
number of instances (which will be recognized with a value higher than 2 in
the \code{reps} column), the other ones will be assigned an \code{NA} at the
\code{reps} value.
}
\examples{

  # An edgelist with duplicated dyads
  relations <- cbind(c(1,1,3,3,4,2,5,6), c(2,3,1,1,2,4,1,1))
  
  # Checking duplicated edges (undirected graph)
  check.dpl.edges(edges=relations, undirected=TRUE)
}
\seealso{
Other manipulation: 
\code{\link{switch.edges}()}
}
\author{
George Vega Yon
}
\concept{manipulation}
\keyword{manip}
