#' View All Linked payment Methods.
#'
#' @name pymt_methods
#'
#' @description This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. These keys must have the appropriate access. Note that for this function to work, the API key must have transfer access.
#'
#' @param api.key Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.
#' @param secret Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.
#' @param passphrase Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.
#'
#' @return A named list.
#'
#' @examples
#' \dontrun{
#' pmt_methods(api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
#' }
#'
#' @export

# output tested on WIN. Macos pending
pymt_methods <- function(api.key,
                         secret,
                         passphrase) {
  #get url extension----
  req.url = "/payment-methods"

  #get method----
  method = "GET"

  #fetch response----
  payment_methods <- auth(
    method = method,
    req.url = req.url,
    api.key = api.key,
    secret = secret,
    passphrase = passphrase
  )

  #transform----
  payment_methods <- ldply(payment_methods, as.data.frame)

  #return----
  return(payment_methods)
}
