/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.grid.neighborhood;

import org.flsgen.exception.FlsgenException;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.neighborhood.regular.square.FourConnected;
import org.flsgen.grid.neighborhood.regular.square.HeightConnected;
import org.flsgen.grid.neighborhood.regular.square.KWideFourConnected;
import org.flsgen.grid.neighborhood.regular.square.KWideHeightConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialFourConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialHeightConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialKWideFourConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialKWideHeightConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialTwoWideFourConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialTwoWideHeightConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialVariableWidthFourConnected;
import org.flsgen.grid.neighborhood.regular.square.PartialVariableWidthHeightConnected;
import org.flsgen.grid.neighborhood.regular.square.TwoWideFourConnected;
import org.flsgen.grid.neighborhood.regular.square.TwoWideHeightConnected;
import org.flsgen.grid.neighborhood.regular.square.VariableWidthFourConnected;
import org.flsgen.grid.neighborhood.regular.square.VariableWidthHeightConnected;
import org.flsgen.grid.regular.square.PartialRegularSquareGrid;
import org.flsgen.grid.regular.square.RegularSquareGrid;

public class Neighborhoods {
    public static final FourConnected FOUR_CONNECTED = new FourConnected();
    public static final HeightConnected HEIGHT_CONNECTED = new HeightConnected();
    public static final PartialFourConnected PARTIAL_FOUR_CONNECTED = new PartialFourConnected();
    public static final PartialHeightConnected PARTIAL_HEIGHT_CONNECTED = new PartialHeightConnected();
    public static final TwoWideHeightConnected TWO_WIDE_HEIGHT_CONNECTED = new TwoWideHeightConnected();
    public static final TwoWideFourConnected TWO_WIDE_FOUR_CONNECTED = new TwoWideFourConnected();
    public static final PartialTwoWideFourConnected PARTIAL_TWO_WIDE_FOUR_CONNECTED = new PartialTwoWideFourConnected();
    public static final PartialTwoWideHeightConnected PARTIAL_TWO_WIDE_HEIGHT_CONNECTED = new PartialTwoWideHeightConnected();

    public static final KWideFourConnected K_WIDE_FOUR_CONNECTED(int k) {
        return new KWideFourConnected(k);
    }

    public static final PartialKWideFourConnected PARTIAL_K_WIDE_FOUR_CONNECTED(int k) {
        return new PartialKWideFourConnected(k);
    }

    public static final VariableWidthFourConnected VARIABLE_WIDTH_FOUR_CONNECTED(int minWidth, int maxWidth) throws FlsgenException {
        return new VariableWidthFourConnected(minWidth, maxWidth);
    }

    public static final PartialVariableWidthFourConnected PARTIAL_VARIABLE_WIDTH_FOUR_CONNECTED(int minWidth, int maxWidth) throws FlsgenException {
        return new PartialVariableWidthFourConnected(minWidth, maxWidth);
    }

    public static final KWideHeightConnected K_WIDE_HEIGHT_CONNECTED(int k) {
        return new KWideHeightConnected(k);
    }

    public static final PartialKWideHeightConnected PARTIAL_K_WIDE_HEIGHT_CONNECTED(int k) {
        return new PartialKWideHeightConnected(k);
    }

    public static final VariableWidthHeightConnected VARIABLE_WIDTH_HEIGHT_CONNECTED(int minWidth, int maxWidth) throws FlsgenException {
        return new VariableWidthHeightConnected(minWidth, maxWidth);
    }

    public static final PartialVariableWidthHeightConnected PARTIAL_VARIABLE_WIDTH_HEIGHT_CONNECTED(int minWidth, int maxWidth) throws FlsgenException {
        return new PartialVariableWidthHeightConnected(minWidth, maxWidth);
    }

    public static INeighborhood resolveNeighborhood(RegularSquareGrid grid, int neigh, int width) throws FlsgenException {
        if (neigh == 4) {
            return Neighborhoods.resolveFourConnected(grid, width);
        }
        if (neigh == 8) {
            return Neighborhoods.resolveHeightConnected(grid, width);
        }
        throw new FlsgenException("Available neighborhoods are: four-connected (4) and height-connected (8)");
    }

    public static INeighborhood resolveNeighborhood(RegularSquareGrid grid, int neigh, int minWidth, int maxWidth) throws FlsgenException {
        if (neigh == 4) {
            return Neighborhoods.resolveVariableFourConnected(grid, minWidth, maxWidth);
        }
        if (neigh == 8) {
            return Neighborhoods.resolveVariableHeightConnected(grid, minWidth, maxWidth);
        }
        throw new FlsgenException("Available neighborhoods are: four-connected (4) and height-connected (8)");
    }

    public static final INeighborhood resolveFourConnected(RegularSquareGrid grid, int width) {
        if (grid instanceof PartialRegularSquareGrid) {
            switch (width) {
                case 1: {
                    return PARTIAL_FOUR_CONNECTED;
                }
                case 2: {
                    return PARTIAL_TWO_WIDE_FOUR_CONNECTED;
                }
            }
            return Neighborhoods.PARTIAL_K_WIDE_FOUR_CONNECTED(width);
        }
        switch (width) {
            case 1: {
                return FOUR_CONNECTED;
            }
            case 2: {
                return TWO_WIDE_FOUR_CONNECTED;
            }
        }
        return Neighborhoods.K_WIDE_FOUR_CONNECTED(width);
    }

    public static final INeighborhood resolveVariableFourConnected(RegularSquareGrid grid, int minWidth, int maxWidth) throws FlsgenException {
        if (grid instanceof PartialRegularSquareGrid) {
            return Neighborhoods.PARTIAL_VARIABLE_WIDTH_FOUR_CONNECTED(minWidth, maxWidth);
        }
        return Neighborhoods.VARIABLE_WIDTH_FOUR_CONNECTED(minWidth, maxWidth);
    }

    public static final INeighborhood resolveHeightConnected(RegularSquareGrid grid, int width) {
        if (grid instanceof PartialRegularSquareGrid) {
            switch (width) {
                case 1: {
                    return PARTIAL_HEIGHT_CONNECTED;
                }
                case 2: {
                    return PARTIAL_TWO_WIDE_HEIGHT_CONNECTED;
                }
            }
            return Neighborhoods.PARTIAL_K_WIDE_HEIGHT_CONNECTED(width);
        }
        switch (width) {
            case 1: {
                return HEIGHT_CONNECTED;
            }
            case 2: {
                return TWO_WIDE_HEIGHT_CONNECTED;
            }
        }
        return Neighborhoods.K_WIDE_HEIGHT_CONNECTED(width);
    }

    public static final INeighborhood resolveVariableHeightConnected(RegularSquareGrid grid, int minWidth, int maxWidth) throws FlsgenException {
        if (grid instanceof PartialRegularSquareGrid) {
            return Neighborhoods.PARTIAL_VARIABLE_WIDTH_HEIGHT_CONNECTED(minWidth, maxWidth);
        }
        return Neighborhoods.VARIABLE_WIDTH_HEIGHT_CONNECTED(minWidth, maxWidth);
    }
}

