% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather_windows.R
\name{weather_windows}
\alias{weather_windows}
\title{Compute Weather Windows}
\usage{
weather_windows(
  valid_periods,
  window_length,
  allow_overlap = TRUE,
  time_step = 3600
)
}
\arguments{
\item{valid_periods}{A data frame with a 'time' column (POSIXct).}

\item{window_length}{Minimum window duration (hours).}

\item{allow_overlap}{Logical; If TRUE, the algorithm searches for window,
if a window is found, search of next window will start from the end of the previous window.
If FALSE, it uses continuous window search: The algorithm searches for window starting from
every time step that meets the criteria.}

\item{time_step}{Expected time step between consecutive timestamps (seconds).}
}
\value{
POSIXct vector of detected window start times.
}
\description{
Computes and returns start date of each weather window, implemented in C++ for speed.
}
